/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.options;

import java.util.Locale;
import java.util.Map;
import org.eclipse.escet.cif.plcgen.options.InputOutputCodeForm;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class InputOutputCodeFormOption
extends EnumOption<InputOutputCodeForm> {
    private static final String LONG_OPTION_TEXT = "input-output-code-form";
    private static final String BOTH_MAIN_EXPLAIN = "both input and output code are in the main program";
    private static final String INPUT_MAIN_EXPLAIN = "input code in the main program and output code in a function";
    private static final String OUTPUT_MAIN_EXPLAIN = "input code in a function and output code in the main program";
    private static final String BOTH_FUNC_EXPLAIN = "both input and output code each in their own function";
    private static final Map<String, InputOutputCodeForm> OPTION_VALUES = Map.of("both-main", InputOutputCodeForm.INPUT_MAIN_AND_OUTPUT_MAIN, "input-main-output-func", InputOutputCodeForm.INPUT_MAIN_AND_OUTPUT_FUNC, "input-func-output-main", InputOutputCodeForm.INPUT_FUNC_AND_OUTPUT_MAIN, "both-func", InputOutputCodeForm.INPUT_FUNC_AND_OUTPUT_FUNC);

    public InputOutputCodeFormOption() {
        super("Input/output code form", "Where to generate input and output code. Choose between: both input and output code are in the main program (FORM=both-main), or input code in the main program and output code in a function (FORM=input-main-output-func), or input code in a function and output code in the main program (FORM=input-func-output-main), or both input and output code each in their own function (FORM=both-func). [DEFAULT=both-main]", null, LONG_OPTION_TEXT, "FORM", (Enum)InputOutputCodeForm.INPUT_MAIN_AND_OUTPUT_MAIN, true, "Where to generate input and output code.");
    }

    public InputOutputCodeForm parseValue(String optName, String value) {
        InputOutputCodeForm enumValue = OPTION_VALUES.get(value.toLowerCase(Locale.US));
        if (enumValue == null) {
            throw new InvalidOptionException("Unknown option value.");
        }
        return enumValue;
    }

    public String[] getCmdLine(Object value) {
        InputOutputCodeForm form = (InputOutputCodeForm)((Object)value);
        for (Map.Entry<String, InputOutputCodeForm> entry : OPTION_VALUES.entrySet()) {
            if (entry.getValue() != form) continue;
            return new String[]{Strings.fmt((String)"--%s=%s", (Object[])new Object[]{LONG_OPTION_TEXT, entry.getKey()})};
        }
        throw new AssertionError((Object)("Command line conversion of \"" + String.valueOf(value) + "\" failed."));
    }

    protected String getDialogText(InputOutputCodeForm value) {
        return switch (value) {
            case InputOutputCodeForm.INPUT_MAIN_AND_OUTPUT_MAIN -> this.formatExplanation(BOTH_MAIN_EXPLAIN);
            case InputOutputCodeForm.INPUT_MAIN_AND_OUTPUT_FUNC -> this.formatExplanation(INPUT_MAIN_EXPLAIN);
            case InputOutputCodeForm.INPUT_FUNC_AND_OUTPUT_MAIN -> this.formatExplanation(OUTPUT_MAIN_EXPLAIN);
            case InputOutputCodeForm.INPUT_FUNC_AND_OUTPUT_FUNC -> this.formatExplanation(BOTH_FUNC_EXPLAIN);
            default -> throw new AssertionError((Object)("Unexpected enumeration literal \"" + String.valueOf((Object)value) + "\"."));
        };
    }

    private String formatExplanation(String explanation) {
        return Strings.makeInitialUppercase((String)explanation) + ".";
    }

    public static InputOutputCodeForm getValue() {
        return (InputOutputCodeForm)((Object)Options.get(InputOutputCodeFormOption.class));
    }
}

