/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui.commands;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.escet.common.app.framework.appsview.ui.AppsView;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.TerminateCommandBase;
import org.eclipse.escet.common.app.framework.management.AppManager;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TerminateAllCommand
extends TerminateCommandBase {
    @Override
    public String getIconUri() {
        return "platform:/plugin/org.eclipse.escet.common.app.framework.appsview.ui/icons/command_terminate_all.png";
    }

    @Override
    public String getItemLabel() {
        return "&Terminate All";
    }

    @Override
    public String getTooltip() {
        return "Terminate all listed applications";
    }

    @Override
    public String getContributionUri() {
        return "bundleclass://org.eclipse.escet.common.app.framework.appsview.ui/" + this.getClass().getName();
    }

    @Override
    public ItemType getItemType() {
        return ItemType.PUSH;
    }

    @CanExecute
    public boolean isEnabled(MPart part) {
        return this.canTerminate(part);
    }

    private boolean canTerminate(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return false;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return false;
        }
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.canTerminate(view, item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void execute(MPart part) {
        AppManager.terminateAll();
    }
}

