/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.targets;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcBaseTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.TwinCatWriter;
import org.eclipse.escet.cif.plcgen.writers.Writer;

public class TwinCatTarget
extends PlcBaseTarget {
    public TwinCatTarget() {
        super(PlcTargetType.TWINCAT, ConvertEnums.KEEP);
    }

    @Override
    public Writer getPlcCodeWriter() {
        return new TwinCatWriter(this);
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    @Override
    public boolean supportsConstant(Constant constant) {
        return TwinCatTarget.commonSupportedConstants(constant);
    }

    @Override
    public EnumSet<PlcBasicFuncDescription.PlcFuncNotation> getSupportedFuncNotations(PlcFuncOperation funcOper, int numArgs) {
        EnumSet<PlcBasicFuncDescription.PlcFuncNotation> funcSupport = super.getSupportedFuncNotations(funcOper, numArgs);
        if (funcOper == PlcFuncOperation.AND_SHORT_CIRCUIT_OP || funcOper == PlcFuncOperation.OR_SHORT_CIRCUIT_OP) {
            funcSupport = EnumSet.copyOf(funcSupport);
            funcSupport.addAll(PlcBasicFuncDescription.PlcFuncNotation.ALL);
            return funcSupport;
        }
        return funcSupport;
    }

    @Override
    public int getExprPriority(PlcBasicFuncDescription.ExprBinding exprBinding) {
        return switch (exprBinding) {
            case PlcBasicFuncDescription.ExprBinding.UNARY_NEGATE, PlcBasicFuncDescription.ExprBinding.UNARY_NOT -> 1;
            case PlcBasicFuncDescription.ExprBinding.BINARY_MUL, PlcBasicFuncDescription.ExprBinding.BINARY_DIV, PlcBasicFuncDescription.ExprBinding.BINARY_MOD -> 3;
            case PlcBasicFuncDescription.ExprBinding.BINARY_SUB, PlcBasicFuncDescription.ExprBinding.BINARY_ADD -> 4;
            case PlcBasicFuncDescription.ExprBinding.BINARY_LESS_THAN, PlcBasicFuncDescription.ExprBinding.BINARY_LESS_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_THAN, PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_EQUAL -> 5;
            case PlcBasicFuncDescription.ExprBinding.BINARY_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_UNEQUAL -> 5;
            case PlcBasicFuncDescription.ExprBinding.BINARY_AND -> 7;
            case PlcBasicFuncDescription.ExprBinding.BINARY_XOR -> 9;
            case PlcBasicFuncDescription.ExprBinding.BINARY_OR -> 9;
            case PlcBasicFuncDescription.ExprBinding.NO_PRIORITY -> Integer.MAX_VALUE;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public PlcBasicFuncDescription.ExprAssociativity getExprAssociativity(PlcBasicFuncDescription.ExprBinding exprBinding) {
        if (EnumSet.of(PlcBasicFuncDescription.ExprBinding.BINARY_LESS_THAN, new PlcBasicFuncDescription.ExprBinding[]{PlcBasicFuncDescription.ExprBinding.BINARY_LESS_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_THAN, PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_UNEQUAL}).contains((Object)exprBinding)) {
            return PlcBasicFuncDescription.ExprAssociativity.ALWAYS;
        }
        return super.getExprAssociativity(exprBinding);
    }

    @Override
    public List<PlcElementaryType> getSupportedIntegerTypes() {
        return PlcElementaryType.INTEGER_TYPES_64;
    }

    @Override
    public List<PlcElementaryType> getSupportedRealTypes() {
        return PlcElementaryType.REAL_TYPES_64;
    }

    @Override
    public List<PlcElementaryType> getSupportedBitStringTypes() {
        return PlcElementaryType.BIT_STRING_TYPES_64;
    }

    @Override
    public String getPathSuffixReplacement() {
        return "_twincat";
    }
}

