/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.emfstore.internal.client.model.Activator;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecordingHint;
import org.eclipse.emf.emfstore.internal.common.model.util.NotificationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationRecording {
    private List<NotificationInfo> chain = new LinkedList<NotificationInfo>();
    private NotificationRecordingHint hint;
    private Date date;

    public NotificationRecordingHint getHint() {
        return this.hint;
    }

    public void setHint(NotificationRecordingHint hint) {
        this.hint = hint;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void record(Notification n) {
        this.chain.add(new NotificationInfo(n));
    }

    public NotificationInfo getLastRecorded() {
        if (this.empty()) {
            return null;
        }
        return this.chain.get(this.chain.size() - 1);
    }

    public boolean empty() {
        return this.chain.size() == 0;
    }

    public void debugLog(String msg) {
        Activator activator = Activator.getDefault();
        MultiStatus status = new MultiStatus(activator.getBundle().getSymbolicName(), 0, msg, null);
        LinkedList<Status> temp = new LinkedList<Status>();
        for (NotificationInfo n : this.chain) {
            temp.add(new Status(0, activator.getBundle().getSymbolicName(), String.valueOf(n.getDebugString()) + " ----------------------- " + n.toString()));
        }
        Collections.reverse(temp);
        for (Status s : temp) {
            status.add((IStatus)s);
        }
        activator.getLog().log((IStatus)status);
    }

    public void debugLog() {
        String hintType = "DEFAULT";
        if (this.getHint().equals(NotificationRecordingHint.DELETE)) {
            hintType = "DELETE";
        }
        if (!Configuration.getVersioningInfo().isReleaseVersion()) {
            this.debugLog("captured notification chain: " + hintType + " operation");
        }
    }

    public List<NotificationInfo> asMutableList() {
        return this.chain;
    }
}

