/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DescriptionProvider;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.MergeLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecisionUtil {
    public static final int OPTION_LENGTH = 45;
    public static final String SEPERATOR = "#";
    public static final String EDITABLE = "editable";
    public static final String WIDGET_MULTILINE = "org.eclipse.emf.emfstore.client.ui.merge.widget.multiline";
    public static final String WIDGET_MULTILINE_EDITABLE = "org.eclipse.emf.emfstore.client.ui.merge.widget.multiline#editable";
    private static DescriptionProvider descriptionProvider;

    private DecisionUtil() {
    }

    public static String cutString(String str, int length, boolean addPoints) {
        if (str == null) {
            return "";
        }
        if (str.length() > length) {
            str = str.substring(0, length);
            if (addPoints) {
                str = String.valueOf(str) + "...";
            }
            return str;
        }
        return str;
    }

    public static String stripNewLine(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("\n\r|\r\n|\n \r|\r \n|\n|\r", " ");
    }

    public static ConflictOption getConflictOptionByType(List<ConflictOption> options, ConflictOption.OptionType type) {
        for (ConflictOption option : options) {
            if (!option.getType().equals((Object)type)) continue;
            return option;
        }
        return null;
    }

    public static boolean detailsNeeded(VisualConflict conflict) {
        if (!conflict.hasDetails()) {
            return false;
        }
        for (ConflictOption option : conflict.getOptions()) {
            if (!option.isDetailsProvider() || !option.getDetailProvider().startsWith(WIDGET_MULTILINE) || option.getOptionLabel().length() <= 45) continue;
            return true;
        }
        return false;
    }

    public static String getDescription(String key, boolean isBranchMerge) {
        if (descriptionProvider == null) {
            descriptionProvider = new DescriptionProvider();
        }
        descriptionProvider.setPrefix(isBranchMerge ? "branchmerge" : null);
        return descriptionProvider.getDescription(key);
    }

    public static String getLabel(Object obj, String unset) {
        return obj != null && obj.toString().length() > 0 ? obj.toString() : unset;
    }

    public static String getClassAndName(EObject modelElement) {
        if (modelElement == null) {
            return "";
        }
        return String.valueOf(modelElement.eClass().getName()) + " \"" + DecisionUtil.getModelElementName(modelElement) + "\"";
    }

    public static String getModelElementName(EObject modelElement) {
        if (modelElement == null) {
            return "";
        }
        MergeLabelProvider labelProvider = (MergeLabelProvider)ESWorkspaceProviderImpl.getObserverBus().notify(MergeLabelProvider.class, true);
        if (labelProvider == null) {
            return modelElement.toString();
        }
        return labelProvider.getText(modelElement);
    }
}

