/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnOpenServerEndpoint.java 74493 2015-05-18 18:15:43Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onopen.srv.toomanyargs;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/invalid")
public class OnOpenServerEndpoint {
	private String open;

	@OnMessage
	public String echo(String echo) {
		return open + echo;
	}

	@OnOpen
	public void onOpen(Session session, String thisShouldNotBeHere) {
		open = "thisShouldNotBeHere";
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}
}
