/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: TestListener.java 74522 2015-06-02 12:05:10Z jsupol $
 */
package com.sun.ts.tests.websocket.negdep.invalidpathparamtype.pasrv.onopen;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.websocket.server.ServerContainer;

@WebListener
public class TestListener implements ServletContextListener {

        /**
         * Receives notification that the web application initialization
         * process is starting.
         *
         * @param sce The ServletContextEvent
         */
        @Override
        public void contextInitialized(ServletContextEvent sce) {
                ServletContext context = sce.getServletContext();
                try {
                        final ServerContainer serverContainer = (ServerContainer) context.getAttribute("javax.websocket.server.ServerContainer");
                        serverContainer.addEndpoint(OnOpenServerEndpoint.class);
                } catch (Exception ex) {
                	//The DeploymentException thrown here should remove all 
                	// endpoints including the EchoServerEndpoint and no more 
                	// endpoint is allowed to be deployed. Because of that, 
                	// the error cannot be passed to client side and it only 
                	// can be logged in into appserver log.
                	ex.printStackTrace();
                }
        }

        /**
         * Receives notification that the servlet context is about to be shut down.
         * @param sce The servlet context event
         */
        public void contextDestroyed(ServletContextEvent sce) {
                // Do nothing
        }
}
