/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCIOTextStreamDecoderServer.java 72879 2013-09-19 15:25:02Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.annotated;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingIOTextStreamDecoder;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingTextDecoder;

@ServerEndpoint(value = "/iotextstreamdecoder", decoders = { ThrowingIOTextStreamDecoder.class })
public class WSCIOTextStreamDecoderServer {

	@OnMessage
	public String echo(StringBean bean, Session session) {
		return bean.get();
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		String message = ThrowingTextDecoder.getCauseMessage(t);
		session.getBasicRemote().sendText(message);
	}

}
