/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCBinaryStreamEncoderServer.java 72876 2013-09-17 12:05:52Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.annotated;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingBinaryStreamEncoder;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingTextDecoder;

@ServerEndpoint(value = "/binarystreamencoder", encoders = { ThrowingBinaryStreamEncoder.class })
public class WSCBinaryStreamEncoderServer {

	@OnMessage
	public void echo(String data, Session session) throws InterruptedException,
			ExecutionException {
		Future<Void> future = session.getAsyncRemote().sendObject(
				new StringBean(data));
		future.get();
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		String message = ThrowingTextDecoder.getCauseMessage(t);
		session.getBasicRemote().sendText(message);
	}

}
