/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ThrowingBinaryEncoder.java 72879 2013-09-19 15:25:02Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder;

import java.nio.ByteBuffer;

import javax.websocket.EncodeException;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryEncoder;

public class ThrowingBinaryEncoder extends StringBeanBinaryEncoder {

    @Override
    public ByteBuffer encode(StringBean bean) throws EncodeException {
        throw new EncodeException(bean.get(), ThrowingTextDecoder.ERR_MSG);
    }
}
