/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSOnClosePathParamServer.java 72768 2013-09-03 09:04:13Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.pathparam;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/onclose")
public class WSOnClosePathParamServer {

	public static final String RESET = "path params has been reset";
	private static final String[] p = new String[11];

	@OnMessage
	public String param(String content) {
		int i = Integer.parseInt(content);
		if (i == -1) {
			for (int j = 0; j != p.length; j++)
				p[j] = "";
			return RESET;
		}
		return get(i);
	}

	public static final void set(int i, String param) {
		p[i] = param;
	}

	private static final String get(int i) {
		return p[i];
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}

}
