/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCIsUserInRoleServer.java 72309 2013-07-09 11:33:22Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.server.handshakerequest;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/isuserinrole", configurator = IsUserInRoleNotAuthenticatedConfigurator.class)
public class WSCIsUserInRoleServer {
	@OnMessage
	public String onMessage(String msg) {
		return msg;
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}

}
