/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.asyncwithhandler;

import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendResult;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient.Entity;
import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;

public class AsyncEndpointCallback extends EndpointCallback {
	protected Entity entity;

	public AsyncEndpointCallback(Entity entity) {
		super();
		this.entity = entity;
	}

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
		RemoteEndpoint.Async endpoint = session.getAsyncRemote();
		SendResult result = null;
		try {
			WaitingSendHandler handler = new WaitingSendHandler();
			endpoint.sendObject(entity.getEntityAt(0), handler);
			result = handler.waitForResult(4);
		} catch (Exception i) {
			throw new RuntimeException(i);
		}
		if (!result.isOK() || result.getException() != null)
			throw new RuntimeException(result.getException());
	}
}
