/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;

@ClientEndpoint(encoders = { BinaryCoderBool.class, BinaryCoderByte.class,
		BinaryCoderChar.class, BinaryCoderDouble.class, BinaryCoderInt.class,
		BinaryCoderLong.class, BinaryCoderFloat.class, BinaryCoderShort.class })
public class WSCBinaryClientEndpoint extends AnnotatedStringClientEndpoint {

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnMessage
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

}
