/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCOtherSideServer.java 72869 2013-09-13 15:24:50Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.basic;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/client")
public class WSCOtherSideServer {

	@OnMessage
	public String onMessage(PongMessage pong) {
		return IOUtil.byteBufferToString(pong.getApplicationData());
	}

	@OnMessage
	public String onMessage(String msg, Session session) {
		return msg;
	}

	@OnMessage
	public String onMessage(ByteBuffer buffer, Session session) {
		String msg = IOUtil.byteBufferToString(buffer);
		return onMessage(msg, session);
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in " + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = "Exception: " + IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}

}
