/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCErrorClientEndpoint.java 72835 2013-09-09 16:00:58Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.endpoint.client;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;

public class WSCErrorClientEndpoint extends StringClientEndpoint {
	private static final String EXCEPTION = "TCK test throwable";

	boolean onErrorCalled = false;

	@Override
	public void onMessage(String msg) {
		super.onMessage(msg);
		OPS op = OPS.valueOf(msg);
		switch (op) {
		case THROW:
			throw new RuntimeException(EXCEPTION);
		default:
			break;
		}
	}

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@Override
	public void onError(Session session, Throwable t) {
		String msg = WebSocketCommonClient.getCauseMessage(t);
		if (EXCEPTION.equals(msg)) {
			onErrorCalled = true;
			getCountDownLatch().countDown();
		} else
			super.onError(session, t);
	}

}
