/*
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.servletcontext;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.descriptor.JspConfigDescriptor;


public class TestServlet extends GenericTCKServlet {

    public void getJspConfigDescriptorTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        JspConfigDescriptor   results = context.getJspConfigDescriptor();
        if ( results != null) {
            passed = false;
            pw.println("Unexpected JspConfigDescriptor exists: " + results);
        } 
        ServletTestUtil.printResult(pw, passed);
    }
}
