/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.sun.ts.tests.servlet.spec.security.secform;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.HttpConstraint;
import javax.annotation.security.DeclareRoles;

/*
 * This servlet is the annotation based equivalent of UnProtectedTestServlet.
 * As such, this declares roles but sets no security constraints and leaves
 * the page unprotected.
 *
 */
@DeclareRoles({"Administrator", "Manager", "VP", "Employee"})
@ServletSecurity(@HttpConstraint(transportGuarantee = TransportGuarantee.NONE))
@WebServlet(urlPatterns={"/UnProtectedAnnoTest"})
public class UnProtectedAnnoTestServlet extends HttpServlet {

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

        PrintWriter out = response.getWriter();
        if (request.getUserPrincipal() == null)
            out.println("The user principal is: " + request.getUserPrincipal() + "<BR>");
        else
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");

        // Output whether the user is in any of the known or an unknown role.
        // Surround these with !'s so they are easier to search for.
        // (i.e. we can search for !true! or !false!)
        out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
        out.println("isUserInRole(\"MGR\"): !" + request.isUserInRole("MGR") + "!<BR>");
        out.println("isUserInRole(\"VP\"): !" + request.isUserInRole("VP") + "!<BR>");
        out.println("isUserInRole(\"EMP\"): !" + request.isUserInRole("EMP") + "!<BR>");

        // Test getRemoteUser() functionality:
        out.println("<BR>");
        out.println("getRemoteUser(): " + request.getRemoteUser());

    }
}

