/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.spec.security.secform;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.HttpConstraint;
import javax.annotation.security.DeclareRoles;


/* 
 * This servlet is the annotation based equivalent of GuestPageTestServlet.
 * As such this declares roles, and specifies that the GET and POST methods
 * can be accessed by all of the declared roles.
 * 
 * This annotation based version of GuestPageTestServlet varies a bit from
 * it because GuestPageTestServlet specifies that GET and POST can be accessed
 * by "Administrator", "Manager", "VP"  *but* all other http methods
 * are left unprotected and so can be accessed by anyone.
 * This servlet specifies that *all* http methods can be accessed by 
 * "Administrator", "Manager", "Employee" (including GET and POST) and NO
 * http methods are left unprotected.  Thus, this servlet is trying to 
 * be more secure yet it still leaves GET & POST accessible to all declared
 * roles just as is done with GuestPageTestServlet.
 *
 */
@DeclareRoles({"Administrator", "Manager", "Employee", "VP"})
@ServletSecurity(@HttpConstraint(rolesAllowed={"Administrator", "Manager", "VP"}))
@WebServlet(name="GuestPageAnnoTest", urlPatterns={"/GuestPageAnnoTest"})
public class GuestPageAnnoTestServlet extends HttpServlet {

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
    }
}

