/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: PartialDDServlet.java 52684 2007-02-12 04:30:10Z lschwenk $
 */
package com.sun.ts.tests.servlet.spec.security.annotations;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;


/*
 * this permits all - since PERMIT is the default
 */
public class PartialDDServlet extends HttpServlet {

    public void doGet(HttpServletRequest request, HttpServletResponse response) 
                      throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        if ((request != null) && (request.getUserPrincipal() != null)) {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        } else {
            out.println("The user principal is null! <BR>");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) 
                      throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        if ((request != null) && (request.getUserPrincipal() != null)) {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        } else {
            out.println("The user principal is null! <BR>");
        }
    }

}

