/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: $
 */
package com.sun.ts.tests.servlet.spec.async;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.AsyncContext;

public class TestServlet extends GenericTCKServlet {
    
    public void test1(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {
        final AsyncContext ac = request.startAsync();

        Timer asyncTimer = new Timer("TestTimer", true);
        asyncTimer.schedule(
                new TimerTask() {

                    @Override
                    public void run() {
                        try {
                            ac.getResponse().getWriter().println("test1_INVOKED");
                            ac.getResponse().getWriter().flush();
                            ac.complete();
                        } catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                },
                1000);
    }
}