/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.webservlet;

import java.io.PrintWriter;

import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;
import com.sun.javatest.Status;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {
        setServletName("TestServlet");
        setContextRoot("/servlet_annotationservlet_webservlet_web");

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     ts_home;
     */

    /* Run test */

    /*
     * @testName: test1
     *
     * @assertion_ids: Servlet:SPEC:221; Servlet:SPEC:221.1; Servlet:SPEC:221.2;
     *                 Servlet:SPEC:221.3; Servlet:SPEC:221.6; Servlet:SPEC:221.7;
     *                 Servlet:SPEC:221.10;
     *                 Servlet:JAVADOC:825;
     *
     * @test_Strategy: Create a servlet Servlet1;
     *                 Define Servlet1 using annotation @WebServlet(String);
     *                 Invoke Servlet1 at the URL specified by @WebServlet;
     *                 Veriy Servlet1 is invoked properly;
     *                 Verify that servlet name is set to the default name;
     */
    public void test1() throws Fault {
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/Servlet1URL HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet1_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet1" +
                "|isAsyncSupported=false");
        invoke();
    }

    /*
     * @testName: test2
     *
     * @assertion_ids: Servlet:SPEC:221; Servlet:SPEC:221.1; Servlet:SPEC:221.2;
     *                 Servlet:SPEC:221.3; Servlet:SPEC:221.4; Servlet:SPEC:221.6;
     *                 Servlet:SPEC:221.7; Servlet:SPEC:221.10;
     *                 Servlet:JAVADOC:825;
     *
     * @test_Strategy: Create a servlet Servlet2;
     *                 Define Servlet2 using annotation @WebServlet(value="");
     *                 Invoke Servlet2 at any of the URLs specified by @WebServlet;
     *                 Veriy Servlet2 is invoked properly;
     *                 Verify that servlet name is set to the default name;
     */
    public void test2() throws Fault {
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/Servlet2URL1 HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet2_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet2" +
                "|isAsyncSupported=false");
        invoke();

        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/Servlet2URL2 HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet2_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet2" +
                "|isAsyncSupported=false");
        invoke();

        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/test/xyz HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet2_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet2" +
                "|isAsyncSupported=false");
        invoke();

        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/x/y/t.html HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet2_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet2" +
                "|isAsyncSupported=false");
        invoke();
    }

    /*
     * @testName: test3
     *
     * @assertion_ids: Servlet:SPEC:221; Servlet:SPEC:221.1; Servlet:SPEC:221.2;
     *                 Servlet:SPEC:221.3; Servlet:SPEC:221.4; Servlet:SPEC:221.7;
     *                 Servlet:SPEC:221.10;
     *                 Servlet:JAVADOC:819; Servlet:JAVADOC:822; Servlet:JAVADOC:825;
     *
     * @test_Strategy: Create a servlet Servlet3;
     *                 Define Servlet3 using annotation
     *                 @WebServlet(value="", initParams={}, name="")
     *                 Invoke Servlet3 at the URL specified by @WebServlet;
     *                 Veriy Servlet3 is invoked and
     *                 -- value is set correctly
     *                 -- all @initParams are passed correctly.
     *                 -- servlet name is set correctly
     */
    public void test3() throws Fault {
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/Servlet3URL HTTP/1.1");
        TEST_PROPS.setProperty(UNORDERED_SEARCH_STRING, "Servlet3_INVOKED|initParams:" +
                "|name1=value1|name2=value2" +
                "|servletname=Servlet3" + "|isAsyncSupported=false");
        invoke();
    }

    /*
     * @testName: test4
     *
     * @assertion_ids: Servlet:SPEC:221; Servlet:SPEC:221.1; Servlet:SPEC:221.2;
     *                 Servlet:SPEC:221.3; Servlet:SPEC:221.4; Servlet:SPEC:221.7;
     *                 Servlet:SPEC:221.10;
     *                 Servlet:JAVADOC:817; Servlet:JAVADOC:819;
     *                 Servlet:JAVADOC:822; Servlet:JAVADOC:825;
     *
     * @test_Strategy: Create a servlet Servlet4;
     *                 Define Servlet4 using annotation:
     *                 @WebServlet(urlPatterns="", asyncSupported = true, initParams={}, name="")
     *                 Invoke Servlet4 at the URLs specified by @WebServlet;
     *                 Veriy Servlet4 is invoked and
     *                 -- all @initParams are passed correctly.
     *                 -- servlet name is set correctly
     *                 -- async support is set correctly
     */
    public void test4() throws Fault {
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/Servlet4URL/ HTTP/1.1");
        TEST_PROPS.setProperty(UNORDERED_SEARCH_STRING, "Servlet4_INVOKED" +
                "|ServletName=Servlet4" + "isAsyncSupported=true" +
                "|initParams:|name1=value1|name2=value2");
        invoke();
    }

    /*
     * @testName: test5
     *
     * @assertion_ids: Servlet:SPEC:221; Servlet:SPEC:221.1; Servlet:SPEC:221.2;
     *                 Servlet:SPEC:221.3; Servlet:SPEC:221.4; Servlet:SPEC:221.6;
     *                 Servlet:SPEC:221.7; Servlet:SPEC:221.10;
     *                 Servlet:JAVADOC:825;
     *
     * @test_Strategy: Create a servlet Servlet5;
     *                 Define Servlet5 using annotation @WebServlet(urlPatterns="");
     *                 Invoke Servlet5 at any of the URLs specified by @WebServlet;
     *                 Veriy Servlet5 is invoked properly;
     *                 Verify that servlet name is set to the default name;
     */
    public void test5() throws Fault {
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/Servlet5URL1 HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet5_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet5" +
                "|isAsyncSupported=false");
        invoke();

        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/Servlet5URL2 HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet5_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet5" +
                "|isAsyncSupported=false");
        invoke();

        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/test5/xyz HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet5_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet5" +
                "|isAsyncSupported=false");
        invoke();

        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/x/y/z.txt HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "Servlet5_INVOKED" +
                "|servletname=com.sun.ts.tests.servlet.spec.annotationservlet.webservlet.Servlet5" +
                "|isAsyncSupported=false");
        invoke();
    }
}
