/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.weblistener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

@WebListener(value = "ContextListener")
public final class ContextListener
        implements ServletContextListener {

    private ServletContext context = null;

    public void contextDestroyed(ServletContextEvent event) {
        createAttribute("ContextDestroyed");
        this.context = null;
    }

    public void contextInitialized(ServletContextEvent event) {
        this.context = event.getServletContext();
        createAttribute("ContextInitialized");
    }

    private void createAttribute(String s) {
        String tmp = null;
        Object o = context.getAttribute("ContextListener");
        if (o != null) {
            if (o instanceof String) {
                tmp = (String) o + s;
            }
        } else {
            tmp = s;
        }
        context.setAttribute("ContextListener", tmp);
    }
}
