/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.readlistener1;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value = "/TestServlet", asyncSupported = true)
public class TestServlet extends HttpTCKServlet {

    public void nioInputTest1(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {

        AsyncContext ac = request.startAsync();
        ServletOutputStream output = response.getOutputStream();
        ServletInputStream input = request.getInputStream();

        try {
            input.setReadListener(null);
        } catch (NullPointerException npe) {
            output.println("Test PASSED - expected NullPointerException thrown.");
        }
        ac.complete();
    }

	public void nioInputTest2(HttpServletRequest request,
			HttpServletResponse response)
			throws ServletException, IOException {
		AsyncContext ac = null;

		String where = (String) request.getAttribute("WHERE");
		if ("ASYNC".equals(where)) {
			ServletOutputStream output = response.getOutputStream();
			ServletInputStream input = request.getInputStream();
			TestListener readListener = new TestListener(input, output, ac);

			try {
				input.setReadListener(readListener);
			} catch (IllegalStateException npe) {
				output.println("Test PASSED - expected IllegalStateException thrown.");
			}
		} else {
			ac = request.startAsync();
			request.setAttribute("WHERE", "ASYNC");
			ac.dispatch();
		}

	}
}
