/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.asynccontext;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

public final class ACListener1 implements AsyncListener {

    public ACListener1() throws IOException {
    }

    public void onError(AsyncEvent event) throws IOException {
        event.getAsyncContext().getResponse().getWriter().println("in onError method of ACListener1");
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        event.getAsyncContext().getResponse().getWriter().println("in onStartAsync method of ACListener1");
    }

    public void onComplete(AsyncEvent event) throws IOException {
        throw new IOException("in onComplete method of ACListener1");
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        event.getAsyncContext().getResponse().getWriter().println("in onTimeout method of ACListener1");
    }
}
