/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext303;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TestServlet extends GenericTCKServlet {

    public void negativeaddSRAListenerClassTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener(com.sun.ts.tests.servlet.api.common.sharedfiles.SRAttributeListener.class);
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddSRAListenerStringTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener("com.sun.ts.tests.servlet.api.common.sharedfiles.SRAttributeListener");
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddSRListenerClassTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener(com.sun.ts.tests.servlet.api.common.sharedfiles.SRListener.class);
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddSRListenerStringTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener("com.sun.ts.tests.servlet.api.common.sharedfiles.SRListener");
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddSCAListenerClassTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener(com.sun.ts.tests.servlet.api.common.sharedfiles.SCAttributeListener.class);
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddSCAListenerStringTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener("com.sun.ts.tests.servlet.api.common.sharedfiles.SCAttributeListener");
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddSCListenerClassTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener(com.sun.ts.tests.servlet.api.common.sharedfiles.SCListener.class);
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddSCListenerStringTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener("com.sun.ts.tests.servlet.api.common.sharedfiles.SCListener");
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
                exf.printStackTrace(pw);
            }
            ServletTestUtil.printResult(pw, passed);
        }
    }
}
