/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext30;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;

public final class AddFilterNotFound implements Filter {

    // The filter configuration object we are associated with.  If this value
    // is null, this filter instance is not currently configured.
    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {

        if (filterConfig == null)
            throw new ServletException("doFilter of AddFilterNotFound was called but this filter instance is not currently configured");

        ArrayList result =
                (ArrayList) filterConfig.getServletContext().getAttribute("arraylist");
        result.add("ADD_FILTER_NOTFOUND_INVOKED");

        filterConfig.getServletContext().setAttribute("arraylist", result);
        chain.doFilter(request, response);
    }

    // Remove the filter configuration object for this filter.
    public void destroy() {
    }

    //  initialize the filter configuration object for this filter.
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}
