/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.getdefaultsessiontrackingmodes;

import com.sun.javatest.Status;
import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;
import java.io.PrintWriter;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setContextRoot("/servlet_sci_getdefaultsessiontrackingmode_web");
        setServletName("TestServlet");

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     ts_home;
     */
    /* Run test */
    /*
     * @testName:  getDefaultSessionTrackingModes
     *
     * @assertion_ids: Servlet:JAVADOC:684.1;
     *
     * @test_Strategy: Create a ServletContextInitializer, in which,
     *                 Add a ServletContextListener instance using ServletContext.addListener;
     *                 in the ServletContextListener call ServletContext.getDefaultSessionTrackingModes()
     *                 Verify that UnsupportedOperationException is thrown.
     */
    public void getDefaultSessionTrackingModes() throws Fault {
        TEST_PROPS.setProperty(APITEST, "getDefaultSessionTrackingModes");
        invoke();
    }
}
