/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.common.sharedfiles;

import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;

public final class SRAttributeListener
        implements ServletRequestAttributeListener {

    public void attributeAdded(ServletRequestAttributeEvent event) {
        StaticLog.add("SRAttributeListenerAdded:" + event.getName() + "," +
                event.getValue());

    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        StaticLog.add("SRAttributeListenerRemoved:" + event.getName() + "," +
                event.getValue());
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        StaticLog.add("SRAttributeListenerReplaced:" + event.getName() + "," +
                event.getValue());
    }
}
