/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.ejb;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.common.InnerClassFilenameFilter;
import com.sun.ant.taskdefs.common.Packager;
import com.sun.ant.taskdefs.common.SunRITool;
import com.sun.ant.taskdefs.ejb.EJBDescriptorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.BuildException;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EJBTool
extends SunRITool {
    private String ejbJarSuffix = "_ejb.jar";
    private String descriptorXmlFileName = "";
    private String descriptorRuntimeXmlFileName = "";

    protected void registerKnownDTDs(EJBDescriptorHandler handler) {
        handler.registerDTD(PUBLICID_EJB20, TSBuildListener.getDtdDir(this.getTask().getProject()) + File.separator + DEFAULT_SUNRI13_EJB20_DTD_LOCATION);
    }

    protected EJBDescriptorHandler getDescriptorHandler(File srcDir) {
        EJBDescriptorHandler handler = new EJBDescriptorHandler(this.getTask(), srcDir);
        this.registerKnownDTDs(handler);
        for (Packager.DTDLocation dtdLocation : this.getConfig().dtdLocations) {
            handler.registerDTD(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable parseEjbFiles(String descriptorFileName, SAXParser saxParser) throws IOException, SAXException {
        FileInputStream descriptorStream = null;
        Hashtable ejbFiles = null;
        try {
            descriptorStream = new FileInputStream(new File(this.config.descriptorDir, descriptorFileName));
            saxParser.parse(new InputSource(descriptorStream), (HandlerBase)this.handler);
            ejbFiles = this.handler.getFiles();
        }
        finally {
            if (descriptorStream != null) {
                try {
                    descriptorStream.close();
                }
                catch (IOException closeException) {}
            }
        }
        return ejbFiles;
    }

    public void processDescriptor(String descriptorFileName, SAXParser saxParser) {
        String baseName = this.config.name + "_ejb";
        String jarFileName = baseName + ".jar";
        this.descriptorXmlFileName = this.config.name + "_ejb.xml";
        this.descriptorRuntimeXmlFileName = this.config.name + "_ejb.runtime.xml";
        this.checkConfiguration(this.descriptorXmlFileName, saxParser);
        try {
            this.handler = this.getDescriptorHandler(this.config.srcDir);
            Hashtable ejbFiles = this.parseEjbFiles(this.descriptorXmlFileName, saxParser);
            this.autoCheckExclude(ejbFiles);
            this.addSupportClasses(ejbFiles);
            this.checkAndAddInherited(ejbFiles);
            File jarFile = new File(this.destDir, jarFileName);
            if (this.needToRebuild(ejbFiles, jarFile)) {
                this.log("building " + jarFile.getName() + " with " + String.valueOf(ejbFiles.size()) + " files", 3);
                String publicId = this.handler.getPublicId();
                this.writeJar(baseName, jarFile, ejbFiles, publicId);
            } else {
                this.log(jarFile.toString() + " is up to date.", 3);
            }
        }
        catch (SAXException se) {
            String msg = "SAXException while parsing '" + this.descriptorXmlFileName.toString() + "'. This probably indicates badly-formed XML." + "  Details: " + se.getMessage();
            throw new BuildException(msg, (Throwable)se);
        }
        catch (IOException ioe) {
            String msg = "IOException while parsing'" + this.descriptorXmlFileName.toString() + "'.  This probably indicates that the descriptor" + " doesn't exist. Details: " + ioe.getMessage();
            throw new BuildException(msg, (Throwable)ioe);
        }
    }

    private void writeJar(String baseName, File jarfile, Hashtable files, String publicId) throws BuildException {
        String sFilesToAdd = "";
        String sJarFile = jarfile.getPath();
        if (jarfile.exists()) {
            jarfile.delete();
        }
        for (String entryName : files.keySet()) {
            File entryFile = (File)files.get(entryName);
            this.log("adding file '" + entryName + "'", 3);
            sFilesToAdd = !sFilesToAdd.equals("") ? sFilesToAdd + ":" + entryName : sFilesToAdd + entryName;
            InnerClassFilenameFilter flt = new InnerClassFilenameFilter(entryFile.getName());
            File entryDir = entryFile.getParentFile();
            String[] innerfiles = entryDir.list(flt);
            int n = innerfiles.length;
            for (int i = 0; i < n; ++i) {
                int entryIndex = entryName.lastIndexOf(entryFile.getName()) - 1;
                entryName = entryIndex < 0 ? innerfiles[i] : entryName.substring(0, entryIndex) + File.separatorChar + innerfiles[i];
                entryFile = new File(this.config.srcDir, entryName);
                this.log("adding innerclass file '" + entryName + "'", 3);
                sFilesToAdd = sFilesToAdd + ":" + entryName;
            }
        }
        sLastFilesAdded = sFilesToAdd;
        this.log("sFilesToAdd = " + sFilesToAdd, 3);
        String args = "";
        args = "-ejbJar ";
        args = args + this.config.srcDir.getPath() + " ";
        args = args + sFilesToAdd + " ";
        args = args + this.config.descriptorDir.getPath() + File.separator + this.descriptorXmlFileName + " ";
        args = args + jarfile.getPath();
        this.invokePackager(jarfile, args);
    }
}

