/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.frame.Http2Frame;

public class DataFrame
extends Http2Frame {
    public static final int TYPE = 0;
    public static final int END_STREAM = 1;
    public static final int PADDED = 8;
    private int padLength;
    private final ByteBufferReference[] data;
    private final int dataLength;

    public DataFrame(int n, int n2, ByteBufferReference byteBufferReference) {
        this(n, n2, new ByteBufferReference[]{byteBufferReference});
    }

    public DataFrame(int n, int n2, ByteBufferReference[] byteBufferReferenceArray) {
        super(n, n2);
        this.data = byteBufferReferenceArray;
        this.dataLength = Utils.remaining(byteBufferReferenceArray);
    }

    public DataFrame(int n, int n2, ByteBufferReference[] byteBufferReferenceArray, int n3) {
        this(n, n2, byteBufferReferenceArray);
        if (n3 > 0) {
            this.setPadLength(n3);
        }
    }

    @Override
    public int type() {
        return 0;
    }

    @Override
    int length() {
        return this.dataLength + ((this.flags & 8) != 0 ? this.padLength + 1 : 0);
    }

    @Override
    public String flagAsString(int n) {
        switch (n) {
            case 1: {
                return "END_STREAM";
            }
            case 8: {
                return "PADDED";
            }
        }
        return super.flagAsString(n);
    }

    public ByteBufferReference[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    int getPadLength() {
        return this.padLength;
    }

    public void setPadLength(int n) {
        this.padLength = n;
        this.flags |= 8;
    }

    public int payloadLength() {
        if ((this.flags & 8) != 0) {
            return this.dataLength + (1 + this.padLength);
        }
        return this.dataLength;
    }
}

