package com.sun.ts.tests.securityapi.idstore.ldap.invalidsearchscopeexpr;

import static javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope;
import static javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
import static javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope.ONE_LEVEL;

import com.sun.ts.tests.securityapi.idstore.common.ConfigBean;

import java.io.IOException;

import javax.annotation.security.DeclareRoles;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * Test Servlet that prints out the name of the authenticated caller and whether
 * this caller is in any of the roles {Administrator, Manager, Employee}
 *
 */

@LdapIdentityStoreDefinition(
	    url = "ldap://localhost:11389/",
		callerSearchBase = "ou=caller,dc=securityapi,dc=net",
	    callerSearchFilter = "(&(uid=%s)(objectClass=person))",
	    callerSearchScope = LdapSearchScope.SUBTREE,  
	    callerSearchScopeExpression = "${configBean.priority}",
	    groupSearchBase  = "ou=group,dc=securityapi,dc=net",
		groupSearchFilter = "(&(member=%s)(objectClass=groupOfNames))",
	    groupSearchScope = LdapSearchScope.SUBTREE,
	    groupSearchScopeExpression = "${configBean.searchScopeOneLevel_invalid}"
	)

@DeclareRoles({"Administrator", "Manager", "Employee"})
@WebServlet("/ServletForLdapIDStore")
public class ServletForLdapIDStore extends HttpServlet {   
   

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	 System.out.println("Inside ServletForIDStoreLdapOnly:doGet() ....." + "<BR>");
    	 
    	 System.out.println("............LDAP_URL=${LDAP_URL}");
    	 System.out.println("............LDAP_URL=" + System.getProperty("LDAP_URL"));
    	 
     	
         String webName = null;
         if (request.getUserPrincipal() != null) {
         	System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");             
             webName = request.getUserPrincipal().getName();
         }

         response.getWriter().write("web username: " + webName + "\n");  
    }

}
