/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.ham.workflow.cleansubject;

import java.io.IOException;

import javax.annotation.security.DeclareRoles;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@WebServlet("/servlet")
@DeclareRoles({ "Administrator", "Manager", "Employee" })
@ServletSecurity(@HttpConstraint(rolesAllowed = "Administrator"))
public class Servlet extends HttpServlet {

    private static final long serialVersionUID = 1L;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	System.out.println("Inside Servlet ....." + "<BR>");
        
        response.getWriter().write("This is a servlet \n");

        String webName = null;
        if (request.getUserPrincipal() != null) {
        	System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            System.err.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            webName = request.getUserPrincipal().getName();
        }

        response.getWriter().write("web username: " + webName + "\n");

        response.getWriter().write("The attribute FlagforCleanSubject exist before logout : " 
             + (request.getAttribute("FlagforCleanSubject")!=null) + "\n");

        request.logout();
        
        response.getWriter().write("The attribute FlagforCleanSubject exist after logout : " 
                + (request.getAttribute("FlagforCleanSubject")!=null) + "\n");
    }

}
