/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.ham.form;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;

import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.AnnotationLiteral;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.inject.Inject;
import javax.enterprise.inject.spi.Bean;

@WebServlet("/servlet2")
@ServletSecurity(@HttpConstraint(rolesAllowed = "Administrator"))
public class FormServlet2 extends HttpServlet {

    private static final long serialVersionUID = 1L;
    
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	System.out.println("Inside  FormServlet ....." + "<BR>");
        
        response.getWriter().write("This is a servlet \n");

        try {
            BeanManager bm = CDI.current().getBeanManager();
            
            Set<Bean<?>> beans = bm.getBeans(HttpAuthenticationMechanism.class, new AnnotationLiteral<Any>() {});
            for (Bean<?> bean : beans) {
                response.getWriter().println("Class: " + bean.getBeanClass().getName());
                response.getWriter().println("Types: " + bean.getTypes().toString());
                response.getWriter().println("Qualifier: " + split(bean.getQualifiers()));
                response.getWriter().println("Scope: " + bean.getScope().getSimpleName());
                response.getWriter().println("Have qualifier @Default: " + haveQualifierDefault(bean.getQualifiers()));
                response.getWriter().println("Have scope @ApplicationScoped: " + (bean.getScope() == ApplicationScoped.class));
            }
        } catch (Exception e) {
            throw new ServletException(e);
        }
    }
    
    private String split(Set<Annotation> set) {
        StringBuilder sb = new StringBuilder();
        for (Annotation a : set) {
            sb.append(a.annotationType().getSimpleName()).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    
    private boolean haveQualifierDefault(Set<Annotation> set) {
        
        for (Annotation a : set) {
            if (a.annotationType() == Default.class) {
                return true;
            }
        }
        return false;
    }


}
