/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.javascript.host.CSSStyleDeclaration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.math.NumberUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final long serialVersionUID = -1883166331827717255L;
    private SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private static final Map<String, String> DEFAULT_DISPLAY;

    public ComputedCSSStyleDeclaration() {
    }

    ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getHTMLElement());
        this.getHTMLElement().setDefaults(this);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    void setLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected Map<String, CSSStyleDeclaration.StyleElement> getStyleMap(boolean camelCase) {
        Map<String, CSSStyleDeclaration.StyleElement> styleMap = super.getStyleMap(camelCase);
        if (this.localModifications_ != null) {
            for (CSSStyleDeclaration.StyleElement e : this.localModifications_.values()) {
                String key = e.getName();
                if (camelCase) {
                    key = ComputedCSSStyleDeclaration.camelize(key);
                }
                CSSStyleDeclaration.StyleElement existent = styleMap.get(key);
                CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(key, e.getValue(), e.getIndex());
                if (existent != null && element.isDefault()) continue;
                styleMap.put(key, element);
            }
        }
        return styleMap;
    }

    private String getValue(String currentValue, String defaultValue) {
        if (currentValue.length() == 0) {
            return defaultValue;
        }
        return currentValue;
    }

    @Override
    public String jsxGet_backgroundAttachment() {
        return this.getValue(super.jsxGet_backgroundAttachment(), "scroll");
    }

    @Override
    public String jsxGet_backgroundColor() {
        return this.getValue(super.jsxGet_backgroundColor(), "transparent");
    }

    @Override
    public String jsxGet_backgroundImage() {
        return this.getValue(super.jsxGet_backgroundImage(), "none");
    }

    @Override
    public String jsxGet_backgroundRepeat() {
        return this.getValue(super.jsxGet_backgroundRepeat(), "repeat");
    }

    @Override
    public String jsxGet_borderBottomColor() {
        return this.getValue(super.jsxGet_borderBottomColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderBottomStyle() {
        return this.getValue(super.jsxGet_borderBottomStyle(), "none");
    }

    @Override
    public String jsxGet_borderBottomWidth() {
        return this.getValue(super.jsxGet_borderBottomWidth(), "0px");
    }

    @Override
    public String jsxGet_borderCollapse() {
        return this.getValue(super.jsxGet_borderCollapse(), "separate");
    }

    @Override
    public String jsxGet_borderLeftColor() {
        return this.getValue(super.jsxGet_borderLeftColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderLeftStyle() {
        return this.getValue(super.jsxGet_borderLeftStyle(), "none");
    }

    @Override
    public String jsxGet_borderLeftWidth() {
        return this.getValue(super.jsxGet_borderLeftWidth(), "0px");
    }

    @Override
    public String jsxGet_borderRightColor() {
        return this.getValue(super.jsxGet_borderRightColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderRightStyle() {
        return this.getValue(super.jsxGet_borderRightStyle(), "none");
    }

    @Override
    public String jsxGet_borderRightWidth() {
        return this.getValue(super.jsxGet_borderRightWidth(), "0px");
    }

    @Override
    public String jsxGet_borderSpacing() {
        return this.getValue(super.jsxGet_borderSpacing(), "0px 0px");
    }

    @Override
    public String jsxGet_borderTopColor() {
        return this.getValue(super.jsxGet_borderTopColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderTopStyle() {
        return this.getValue(super.jsxGet_borderTopStyle(), "none");
    }

    @Override
    public String jsxGet_borderTopWidth() {
        return this.getValue(super.jsxGet_borderTopWidth(), "0px");
    }

    @Override
    public String jsxGet_bottom() {
        return this.getValue(super.jsxGet_bottom(), "auto");
    }

    @Override
    public String jsxGet_captionSide() {
        return this.getValue(super.jsxGet_captionSide(), "top");
    }

    @Override
    public String jsxGet_clear() {
        return this.getValue(super.jsxGet_clear(), "none");
    }

    @Override
    public String jsxGet_clip() {
        return this.getValue(super.jsxGet_clip(), "auto");
    }

    @Override
    public String jsxGet_color() {
        return this.getValue(super.jsxGet_color(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_counterIncrement() {
        return this.getValue(super.jsxGet_counterIncrement(), "none");
    }

    @Override
    public String jsxGet_counterReset() {
        return this.getValue(super.jsxGet_counterReset(), "none");
    }

    @Override
    public String jsxGet_cssFloat() {
        return this.getValue(super.jsxGet_cssFloat(), "none");
    }

    @Override
    public String jsxGet_cursor() {
        return this.getValue(super.jsxGet_cursor(), "auto");
    }

    @Override
    public String jsxGet_direction() {
        return this.getValue(super.jsxGet_direction(), "ltr");
    }

    @Override
    public String jsxGet_display() {
        return this.getValue(super.jsxGet_display(), this.getDefaultStyleDisplay());
    }

    private String getDefaultStyleDisplay() {
        String defaultValue = DEFAULT_DISPLAY.get(this.getHTMLElement().jsxGet_tagName());
        if (defaultValue == null) {
            return "block";
        }
        return defaultValue;
    }

    @Override
    public String jsxGet_emptyCells() {
        return this.getValue(super.jsxGet_emptyCells(), "-moz-show-background");
    }

    @Override
    public String jsxGet_fontFamily() {
        return this.getValue(super.jsxGet_fontFamily(), "serif");
    }

    @Override
    public String jsxGet_fontSize() {
        return this.getValue(super.jsxGet_fontSize(), "16px");
    }

    @Override
    public String jsxGet_fontSizeAdjust() {
        return this.getValue(super.jsxGet_fontSizeAdjust(), "none");
    }

    @Override
    public String jsxGet_fontStyle() {
        return this.getValue(super.jsxGet_fontStyle(), "normal");
    }

    @Override
    public String jsxGet_fontVariant() {
        return this.getValue(super.jsxGet_fontVariant(), "normal");
    }

    @Override
    public String jsxGet_fontWeight() {
        return this.getValue(super.jsxGet_fontWeight(), "400");
    }

    @Override
    public String jsxGet_height() {
        return this.getValue(super.jsxGet_height(), "363px");
    }

    @Override
    public String jsxGet_left() {
        return this.getValue(super.jsxGet_left(), "auto");
    }

    @Override
    public String jsxGet_letterSpacing() {
        return this.getValue(super.jsxGet_letterSpacing(), "normal");
    }

    @Override
    public String jsxGet_lineHeight() {
        return this.getValue(super.jsxGet_lineHeight(), "normal");
    }

    @Override
    public String jsxGet_listStyleImage() {
        return this.getValue(super.jsxGet_listStyleImage(), "none");
    }

    @Override
    public String jsxGet_listStylePosition() {
        return this.getValue(super.jsxGet_listStylePosition(), "outside");
    }

    @Override
    public String jsxGet_listStyleType() {
        return this.getValue(super.jsxGet_listStyleType(), "disc");
    }

    @Override
    public String jsxGet_marginBottom() {
        return this.getValue(super.jsxGet_marginBottom(), "0px");
    }

    @Override
    public String jsxGet_marginLeft() {
        return this.getValue(super.jsxGet_marginLeft(), "0px");
    }

    @Override
    public String jsxGet_marginRight() {
        return this.getValue(super.jsxGet_marginRight(), "0px");
    }

    @Override
    public String jsxGet_marginTop() {
        return this.getValue(super.jsxGet_marginTop(), "0px");
    }

    @Override
    public String jsxGet_markerOffset() {
        return this.getValue(super.jsxGet_markerOffset(), "none");
    }

    @Override
    public String jsxGet_maxHeight() {
        return this.getValue(super.jsxGet_maxHeight(), "none");
    }

    @Override
    public String jsxGet_maxWidth() {
        return this.getValue(super.jsxGet_maxWidth(), "none");
    }

    @Override
    public String jsxGet_minHeight() {
        return this.getValue(super.jsxGet_minHeight(), "0px");
    }

    @Override
    public String jsxGet_minWidth() {
        return this.getValue(super.jsxGet_minWidth(), "0px");
    }

    @Override
    public String jsxGet_MozAppearance() {
        return this.getValue(super.jsxGet_MozAppearance(), "none");
    }

    @Override
    public String jsxGet_MozBackgroundClip() {
        return this.getValue(super.jsxGet_MozBackgroundClip(), "border");
    }

    @Override
    public String jsxGet_MozBackgroundInlinePolicy() {
        return this.getValue(super.jsxGet_MozBackgroundInlinePolicy(), "continuous");
    }

    @Override
    public String jsxGet_MozBackgroundOrigin() {
        return this.getValue(super.jsxGet_MozBackgroundOrigin(), "padding");
    }

    @Override
    public String jsxGet_MozBinding() {
        return this.getValue(super.jsxGet_MozBinding(), "none");
    }

    @Override
    public String jsxGet_MozBorderBottomColors() {
        return this.getValue(super.jsxGet_MozBorderBottomColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderLeftColors() {
        return this.getValue(super.jsxGet_MozBorderLeftColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomleft() {
        return this.getValue(super.jsxGet_MozBorderRadiusBottomleft(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomright() {
        return this.getValue(super.jsxGet_MozBorderRadiusBottomright(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopleft() {
        return this.getValue(super.jsxGet_MozBorderRadiusTopleft(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopright() {
        return this.getValue(super.jsxGet_MozBorderRadiusTopright(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRightColors() {
        return this.getValue(super.jsxGet_MozBorderRightColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderTopColors() {
        return this.getValue(super.jsxGet_MozBorderTopColors(), "none");
    }

    @Override
    public String jsxGet_MozBoxAlign() {
        return this.getValue(super.jsxGet_MozBoxAlign(), "stretch");
    }

    @Override
    public String jsxGet_MozBoxDirection() {
        return this.getValue(super.jsxGet_MozBoxDirection(), "normal");
    }

    @Override
    public String jsxGet_MozBoxFlex() {
        return this.getValue(super.jsxGet_MozBoxFlex(), "0");
    }

    @Override
    public String jsxGet_MozBoxOrdinalGroup() {
        return this.getValue(super.jsxGet_MozBoxOrdinalGroup(), "1");
    }

    @Override
    public String jsxGet_MozBoxOrient() {
        return this.getValue(super.jsxGet_MozBoxOrient(), "horizontal");
    }

    @Override
    public String jsxGet_MozBoxPack() {
        return this.getValue(super.jsxGet_MozBoxPack(), "start");
    }

    @Override
    public String jsxGet_MozBoxSizing() {
        return this.getValue(super.jsxGet_MozBoxSizing(), "content-box");
    }

    @Override
    public String jsxGet_MozColumnCount() {
        return this.getValue(super.jsxGet_MozColumnCount(), "auto");
    }

    @Override
    public String jsxGet_MozColumnGap() {
        return this.getValue(super.jsxGet_MozColumnGap(), "0px");
    }

    @Override
    public String jsxGet_MozColumnWidth() {
        return this.getValue(super.jsxGet_MozColumnWidth(), "auto");
    }

    @Override
    public String jsxGet_MozFloatEdge() {
        return this.getValue(super.jsxGet_MozFloatEdge(), "content-box");
    }

    @Override
    public String jsxGet_MozImageRegion() {
        return this.getValue(super.jsxGet_MozImageRegion(), "auto");
    }

    @Override
    public String jsxGet_MozOpacity() {
        return this.getValue(super.jsxGet_MozOpacity(), "1");
    }

    @Override
    public String jsxGet_MozOutlineColor() {
        return this.getValue(super.jsxGet_MozOutlineColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_MozOutlineOffset() {
        return this.getValue(super.jsxGet_MozOutlineOffset(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomleft() {
        return this.getValue(super.jsxGet_MozOutlineRadiusBottomleft(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomright() {
        return this.getValue(super.jsxGet_MozOutlineRadiusBottomright(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopleft() {
        return this.getValue(super.jsxGet_MozOutlineRadiusTopleft(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopright() {
        return this.getValue(super.jsxGet_MozOutlineRadiusTopright(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineStyle() {
        return this.getValue(super.jsxGet_MozOutlineStyle(), "none");
    }

    @Override
    public String jsxGet_MozOutlineWidth() {
        return this.getValue(super.jsxGet_MozOutlineWidth(), "0px");
    }

    @Override
    public String jsxGet_MozUserFocus() {
        return this.getValue(super.jsxGet_MozUserFocus(), "none");
    }

    @Override
    public String jsxGet_MozUserInput() {
        return this.getValue(super.jsxGet_MozUserInput(), "auto");
    }

    @Override
    public String jsxGet_MozUserModify() {
        return this.getValue(super.jsxGet_MozUserModify(), "read-only");
    }

    @Override
    public String jsxGet_MozUserSelect() {
        return this.getValue(super.jsxGet_MozUserSelect(), "auto");
    }

    @Override
    public String jsxGet_opacity() {
        return this.getValue(super.jsxGet_opacity(), "1");
    }

    @Override
    public String jsxGet_outlineColor() {
        return this.getValue(super.jsxGet_outlineColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_outlineOffset() {
        return this.getValue(super.jsxGet_outlineOffset(), "0px");
    }

    @Override
    public String jsxGet_outlineStyle() {
        return this.getValue(super.jsxGet_outlineStyle(), "none");
    }

    @Override
    public String jsxGet_outlineWidth() {
        return this.getValue(super.jsxGet_outlineWidth(), "0px");
    }

    @Override
    public String jsxGet_overflow() {
        return this.getValue(super.jsxGet_overflow(), "visible");
    }

    @Override
    public String jsxGet_overflowX() {
        return this.getValue(super.jsxGet_overflowX(), "visible");
    }

    @Override
    public String jsxGet_overflowY() {
        return this.getValue(super.jsxGet_overflowY(), "visible");
    }

    @Override
    public String jsxGet_paddingBottom() {
        return this.getValue(super.jsxGet_paddingBottom(), "0px");
    }

    @Override
    public String jsxGet_paddingLeft() {
        return this.getValue(super.jsxGet_paddingLeft(), "0px");
    }

    @Override
    public String jsxGet_paddingRight() {
        return this.getValue(super.jsxGet_paddingRight(), "0px");
    }

    @Override
    public String jsxGet_paddingTop() {
        return this.getValue(super.jsxGet_paddingTop(), "0px");
    }

    @Override
    public String jsxGet_position() {
        return this.getValue(super.jsxGet_position(), "static");
    }

    @Override
    public String jsxGet_right() {
        return this.getValue(super.jsxGet_right(), "auto");
    }

    @Override
    public String jsxGet_tableLayout() {
        return this.getValue(super.jsxGet_tableLayout(), "auto");
    }

    @Override
    public String jsxGet_textAlign() {
        return this.getValue(super.jsxGet_textAlign(), "start");
    }

    @Override
    public String jsxGet_textDecoration() {
        return this.getValue(super.jsxGet_textDecoration(), "none");
    }

    @Override
    public String jsxGet_textIndent() {
        return this.getValue(super.jsxGet_textIndent(), "0px");
    }

    @Override
    public String jsxGet_textTransform() {
        return this.getValue(super.jsxGet_textTransform(), "none");
    }

    @Override
    public String jsxGet_top() {
        return this.getValue(super.jsxGet_top(), "auto");
    }

    @Override
    public String jsxGet_unicodeBidi() {
        return this.getValue(super.jsxGet_unicodeBidi(), "normal");
    }

    @Override
    public String jsxGet_verticalAlign() {
        return this.getValue(super.jsxGet_verticalAlign(), "baseline");
    }

    @Override
    public String jsxGet_visibility() {
        return this.getValue(super.jsxGet_visibility(), "visible");
    }

    @Override
    public String jsxGet_whiteSpace() {
        return this.getValue(super.jsxGet_whiteSpace(), "normal");
    }

    @Override
    public String jsxGet_width() {
        String defaultWidth = this.jsxGet_display().equals("none") ? "auto" : "1256px";
        return this.getValue(super.jsxGet_width(), defaultWidth);
    }

    int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width = this.intValue(super.jsxGet_width());
        if (includeBorder) {
            int borderLeft = this.intValue(this.jsxGet_borderLeftWidth());
            int borderRight = this.intValue(this.jsxGet_borderRightWidth());
            width += borderLeft + borderRight;
        }
        if (includePadding) {
            int paddingLeft = this.intValue(this.jsxGet_paddingLeft());
            int paddingRight = this.intValue(this.jsxGet_paddingRight());
            width += paddingLeft + paddingRight;
        }
        return width;
    }

    int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = this.intValue(super.jsxGet_height());
        if (includeBorder) {
            int borderTop = this.intValue(this.jsxGet_borderTopWidth());
            int borderBottom = this.intValue(this.jsxGet_borderBottomWidth());
            height += borderTop + borderBottom;
        }
        if (includePadding) {
            int paddingTop = this.intValue(this.jsxGet_paddingTop());
            int paddingBottom = this.intValue(this.jsxGet_paddingBottom());
            height += paddingTop + paddingBottom;
        }
        return height;
    }

    int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top;
        String p = this.jsxGet_position();
        String t = this.jsxGet_top();
        String b = this.jsxGet_bottom();
        if ("absolute".equals(p) && !"auto".equals(t)) {
            top = this.intValue(t);
        } else if ("absolute".equals(p) && !"auto".equals(b)) {
            top = 0;
            for (DomNode child = this.getHTMLElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getPreviousSibling()) {
                if (!(child instanceof HtmlElement) || child instanceof HtmlHead) continue;
                top += 20;
            }
            top -= this.intValue(b);
        } else {
            top = 0;
            for (DomNode prev = this.getHTMLElement().getDomNodeOrDie().getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                if (!(prev instanceof HtmlElement) || prev instanceof HtmlHead) continue;
                top += 20;
            }
        }
        if (includeMargin) {
            int margin = this.intValue(this.jsxGet_marginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = this.intValue(this.jsxGet_borderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.intValue(this.jsxGet_paddingTop());
            top += padding;
        }
        return top;
    }

    int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        String p = this.jsxGet_position();
        String l = this.jsxGet_left();
        String r = this.jsxGet_right();
        int left = "absolute".equals(p) && !"auto".equals(l) ? this.intValue(l) : ("absolute".equals(p) && !"auto".equals(r) ? 200 - this.intValue(r) : 0);
        if (includeMargin) {
            int margin = this.intValue(this.jsxGet_marginLeft());
            left += margin;
        }
        if (includeBorder) {
            int border = this.intValue(this.jsxGet_borderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.intValue(this.jsxGet_paddingLeft());
            left += padding;
        }
        return left;
    }

    private int intValue(String value) {
        return NumberUtils.toInt((String)value.replaceAll("(\\d+).*", "$1"), (int)0);
    }

    @Override
    public String jsxGet_wordSpacing() {
        return this.getValue(super.jsxGet_wordSpacing(), "normal");
    }

    @Override
    public Object jsxGet_zIndex() {
        Object response = super.jsxGet_zIndex();
        if (response.toString().length() == 0) {
            return "auto";
        }
        return response;
    }

    @Override
    public String jsxFunction_getPropertyValue(String name) {
        String response = Context.toString((Object)ComputedCSSStyleDeclaration.getProperty((Scriptable)this, (String)ComputedCSSStyleDeclaration.camelize(name)));
        if (response == NOT_FOUND) {
            return super.jsxFunction_getPropertyValue(name);
        }
        return response;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "inline");
        map.put("CODE", "inline");
        map.put("LI", "list-item");
        map.put("SPAN", "inline");
        map.put("TABLE", "table");
        map.put("TBODY", "table-row-group");
        map.put("TD", "table-cell");
        map.put("TH", "table-cell");
        map.put("THEAD", "table-header-group");
        map.put("TR", "table-row");
        DEFAULT_DISPLAY = Collections.unmodifiableMap(map);
    }
}

