/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/jstl/common/filters/SimpleXmlFilter.java $ $LastChangedDate: 2011-04-15 11:32:31 -0700 (Fri, 15 Apr 2011) $
 */

package com.sun.ts.tests.jstl.common.filters;

import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleXmlFilter extends XMLFilterImpl {

    /** Creates new SimpleXmlFilter */
    public SimpleXmlFilter() {
    }

/* 
 * public methods
 * ========================================================================
 */
    
    /**
     * When called, an new attribute, 'test', will be added to
     * each element processed.
     */
    public void startElement(String namespaceURI, String localName,  
                             String qualifiedName, Attributes atts) 
    throws SAXException {
        AttributesImpl attributes = new AttributesImpl(atts);
        attributes.addAttribute("", "test", "test", "CDATA", "attrvalue");
        atts = attributes;
        super.startElement(namespaceURI, localName, qualifiedName, atts);
    }
}
