<%--
   Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
   SUN PROPRIETARY/CONFIDENTIAL.  Use is subject license terms.
--%>

<%@ page import="com.sun.ts.tests.jsp.common.util.JspTestUtil,
             javax.el.ValueExpression,
             javax.el.ELContext"%>
<%@ page contentType="text/plain" %>

<%!
private static final String LITERAL_EXPR = "true";
private static final Boolean EXPECTED_VALUE = Boolean.TRUE;
%>

<% 
    if (pageContext != null) {
        ELContext elContext = pageContext.getELContext();

        if (elContext != null) {
            JspApplicationContext jaContext = 
                    JspFactory.getDefaultFactory().getJspApplicationContext(
                    pageContext.getServletContext());
            if (jaContext != null) {
                
                try {

                    // parse the value expression
                    ValueExpression vexp = 
                            jaContext.getExpressionFactory().createValueExpression(
                            elContext, LITERAL_EXPR, EXPECTED_VALUE.getClass());

                    if (vexp != null) {
                
                        Class expectedClass = vexp.getExpectedType();
                        if (expectedClass != Boolean.class) {
                            out.println("Test FAILED. Got type = " + expectedClass.getName());
                            return;
                        }
                        Boolean literalVal = (Boolean) vexp.getValue(elContext);
                        if (!literalVal.equals(EXPECTED_VALUE)) {
                            out.println("Test FAILED. Got literalValue = " + literalVal);
                            return;
                        }
                        out.println("Test PASSED");
                    } 
                    else 
                        out.println("Test FAILED. Null value returned for expression.");
                 } catch (Throwable t) {
                    JspTestUtil.handleThrowable(t, out, "CreateValueExpressionTest");
                 }
            }
            else
                out.println("Test FAILED. Unable to obtain JspApplicationContext");
        }
        else
            out.println("Test FAILED. Unable to obtain ELContext");
    } 
    else 
        out.println("Test FAILED.  Unable to obtain PageContext.");
%>
