/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.spec.el.jsp;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class ELDeferredMethodStringLiteralTag extends SimpleTagSupport {
    private static final String NL = System.getProperty("line.separator", "\n");
    private static final String EXPECTEDSTR = "hello"; 
    private static final double EXPECTEDDBL = 3.1415926;
    private final static double EPSILON = 0.00000001;
    
    private MethodExpression strExpr, dblExpr;

    public void setStrExpr(MethodExpression strExpr) {
        this.strExpr = strExpr;
    }

    public void setDblExpr(MethodExpression dblExpr) {
        this.dblExpr = dblExpr;
    }

    public void doTag() throws JspException, IOException {
        ELContext elContext = getJspContext().getELContext();
        JspWriter out = getJspContext().getOut();
        boolean pass = true;

        try {
            String strResult = (String) strExpr.invoke(elContext, null);
            if (!strResult.equals(EXPECTEDSTR)) {
                pass = false;
                out.println("Test FAILED. Incorrect return value for strResult." + NL +
                	"Expected value: " + EXPECTEDSTR + NL +
                	"Value returned: " + strResult);
            }

            Object objResult = dblExpr.invoke(elContext, null);
            if (!(objResult instanceof Double)) {
                pass = false;
                out.println("Test FAILED. Return value is not a Double:" + NL +
                	objResult.getClass() + NL);
            }
            double dblResult = ((Double) objResult).doubleValue();
            if (!(Math.abs(dblResult - EXPECTEDDBL) < EPSILON)) {
                pass = false;
                out.println("Test FAILED. Incorrect value for dblResult." + NL +
                	"Expected value: " + EXPECTEDDBL + NL +
                	"Value returned: " + dblResult);
            }

            if (pass == true) out.println("Test PASSED."); 

        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "ELDeferredMethodStringLiteralTag");
        }
    }
}
