/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: AllowedDynamicAttributeValueTypesTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.spec.el.jsp;

import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import java.io.IOException;

public class AllowedDynamicAttributeValueTypesTag extends TagSupport {

    private String litExpr;
    private String scriptExpr;
    private String dollarExpr;
    private ValueExpression valueExpr;
    private MethodExpression methodExpr;
    
    private boolean valExprSet;
     
    public void setLitExpr(String litExpr) {
        this.litExpr = litExpr;
    }

    public void setScriptExpr(String scriptExpr) {
        this.scriptExpr = scriptExpr;
    }

    public void setDollarExpr(String dollarExpr) {
        this.dollarExpr = dollarExpr;
    }

    public void setValueExpr(Object expr) {
	if (expr instanceof ValueExpression) {
            this.valueExpr = (ValueExpression) expr;
            valExprSet = true;
	} else { 
	    this.valueExpr = null;
	    valExprSet = false;
        }	        	
    }

    public void setMethodExpr(MethodExpression methodExpr) {
        this.methodExpr = methodExpr;
    }

    public int doStartTag() throws JspException {
        try {
            pageContext.getOut().println("litExpr is " + litExpr);
            pageContext.getOut().println("scriptExpr is " + scriptExpr);
            pageContext.getOut().println("dollarExpr is " + dollarExpr);
            pageContext.getOut().println("valueExpr is " + ((valExprSet) ? valueExpr : "null"));
            pageContext.getOut().println("methodExpr is " + methodExpr); 
	    if (valExprSet)
                pageContext.getOut().println("Test PASSED.");
        } catch (IOException ioe) {
            throw new JspException("Unexpected Exception", ioe);
        }
        return SKIP_BODY;
    }
}
