/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 63771 2011-10-17 12:56:53Z dougd $
 */

package com.sun.ts.tests.jsp.spec.core_syntax.directives.include;


import java.io.PrintWriter;
import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsp.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out), 
                   new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the 
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setGeneralURI("/jsp/spec/core_syntax/directives/include");
        setContextRoot("/jsp_coresyntx_direct_include_web");

        return super.run(args, out, err);
    }

    /*
     *   @class.setup_props:	 webServerHost;
     *				             webServerPort;
     *				             ts_home;
     *
     */

    /*
     *   @testName:  positiveIncludeCtxRelativeDirectiveTest
     *   @assertion_ids: JSP:SPEC:69
     *   @test_Strategy: Using an include directive, include content
     *                   referenced by a context-relative path.
     *   PENDING Merge with test below
     */

    public void positiveIncludeCtxRelativeDirectiveTest() throws Fault {
        TEST_PROPS.setProperty(STANDARD, "positiveIncludeCtxRelativeDirective");
        invoke();
    }

    /*
     *   @testName:  positiveIncludePageRelativeDirectiveTest
     *   @assertion_ids: JSP:SPEC:69
     *   @test_Strategy: Using an include directive, include content
     *                   referenced by a page-relative path.
     */

    public void positiveIncludePageRelativeDirectiveTest() throws Fault {
        TEST_PROPS.setProperty(STANDARD, "positiveIncludePageRelativeDirective");
        invoke();
    }
}
