/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BodyContainerInteractionTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.bodytagsupport;

import com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.tagsupport.ContainerInteractionTag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.BodyContent;

public class BodyContainerInteractionTag extends ContainerInteractionTag
implements BodyTag {

    protected BodyContent _content = null;
    /**
     * Default constructor.
     */
    public BodyContainerInteractionTag() {
        super();
    }

    /**
     * Validate container behavior when returning either
     * EVAL_BODY_INCLUDE, SKIP_BODY, SKIP_PAGE, or EVAL_BODY_BUFFERED.
     * @return an int value based on the doStartTag attribute.
     * @throws JspException if an error occurs
     */
    public int doStartTag() throws JspException {
        int retValue = 0;
        if ("EVAL_BODY_BUFFERED".equals(_doStartTag)) {
            addMethodToList("doStartTag");
            retValue = EVAL_BODY_BUFFERED;
        } else {
            retValue = super.doStartTag();
        }
        return retValue;
    }

    /**
     * Validate the container calls setBodyContent
     * on tag instances when doStartTag() returns
     * EVAL_BODY_BUFFERED.
     * @param content - the body content.
     */
    public void setBodyContent(BodyContent content) {
        _content = content;
        addMethodToList("setBodyContent");
    }

    /**
     * Validate the container calls doInitBody() before
     * the evaluation of the body.
     * @throws JspException if an error occurs
     */
    public void doInitBody() throws JspException {
        addMethodToList("doInitBody");
    }


}
