/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.jspapplicationcontext;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;

/**
 * ServletContextListener that installs the FooELResolver,
 * enabling the use of ${Foo}.
 */
public class InstallFooListener 
    implements ServletContextListener
{
    public void contextInitialized(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        JspApplicationContext jspContext = 
            JspFactory.getDefaultFactory().getJspApplicationContext(context);
        jspContext.addELResolver(new FooELResolver());
    }
    
    public void contextDestroyed(ServletContextEvent evt) {
    }
}
