/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)URLClient.java	
 */

package com.sun.ts.tests.jsp.api.javax_el.compelresolver;

import java.io.PrintWriter;
import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsp.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out), 
                   new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the 
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setContextRoot("/jsp_compelresolver_web");
        setTestJsp("CompositeELResolverTest");

        return super.run(args, out, err);
    }

    /*
     *  @class.setup_props: webServerHost;
     *                      webServerPort;
     *                      ts_home;
     */

    /* Run tests */

    //============================================ Tests ======

    /*
     * @testName: compositeElResolverTest
     * @assertion_ids: EL:JAVADOC:24; EL:JAVADOC:26; EL:JAVADOC:27; 
     *                 EL:JAVADOC:28; EL:JAVADOC:29; EL:JAVADOC:30; 
     *                 EL:JAVADOC:31 
     * @test_Strategy: Obtain a CompositeELResolver via the PageContext
     *   and verify that API calls work as expected:
     *      add()
     *      setValue()
     *      setValue() throws PropertyNotWritableException
     *      getValue()
     *      getType()
     *      isReadOnly()
     *      getCommonPropertyType()
     *      getFeatureDescriptors() 
     */
    public void compositeElResolverTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "compositeElResolverTest");
        invoke();
    }
}
