/*
 * Copyright (c) 2016 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.pointertests;

import com.sun.ts.tests.jsonp.api.common.JsonPTest;
import com.sun.ts.tests.jsonp.api.common.TestResult;

// $Id: PointerTests.java 74775 2017-01-11 10:46:06Z tkraus $
/**
 * {@see <a href="https://tools.ietf.org/html/rfc6901">RFC 6901</a>}:
 * JavaScript Object Notation (JSON) Pointer compatibility tests.<br>
 * JSON-P API defines {@link javax.json.JsonPointer} interface to work with
 * RFC 6901 JSON Pointer.
 */
public class PointerTests extends JsonPTest {

    /**
     * Test JSON-P API response on pointer resolving.<br>
     * Checks set of JSON pointers from sample object of RFC 6901.
     * {@see <a href="https://tools.ietf.org/html/rfc6901#section-4">RFC 6901: 4. Evaluation</a>}
     * and {@see <a href="https://tools.ietf.org/html/rfc6901#section-5">RFC 6901: 5. JSON String Representation</a>}.
     * @throws Fault when this test failed.

     * @testName:      jsonPointerResolveTest
     * @assertion_ids: JSONP:JAVADOC:643; JSONP:JAVADOC:582; JSONP:JAVADOC:583; JSONP:JAVADOC:584;
     *                 JSONP:JAVADOC:661; JSONP:JAVADOC:662; JSONP:JAVADOC:663;
     * @test_Strategy: Test API response on various JSON pointer values.
     */
    public void jsonPointerResolveTest() throws Fault {
        PointerResolve resolveTest = new PointerResolve();
        final TestResult result = resolveTest.test();
        result.eval();
    }

    /**
     * Test JSON-P API response on {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.1">RFC 6902: 4.1. add</a>}
     * operation using RFC 6901 pointer instance.<br>
     * Checks set of simple JSON values.<br>
     * @throws Fault when this test failed.

     * @testName:      jsonPointerAddOperationTest
     * @assertion_ids: JSONP:JAVADOC:642; JSONP:JAVADOC:582; JSONP:JAVADOC:583; JSONP:JAVADOC:584; 
     *                 JSONP:JAVADOC:661; JSONP:JAVADOC:662; JSONP:JAVADOC:663;
     * @test_Strategy: Test API response on various JSON pointer values.
     */
    public void jsonPointerAddOperationTest() throws Fault {
        PointerAdd addTest = new PointerAdd();
        final TestResult result = addTest.test();
        result.eval();
    }

    /**
     * Test JSON-P API response on {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.2">RFC 6902: 4.2. remove</a>}
     * operation using RFC 6901 pointer instance.<br>
     * Checks set of simple JSON values.<br>
     * @throws Fault when this test failed.

     * @testName:      jsonPointerRemoveOperationTest
     * @assertion_ids: JSONP:JAVADOC:644; JSONP:JAVADOC:582; JSONP:JAVADOC:661;
     * @test_Strategy: Test API response on various JSON pointer values.
     */
    public void jsonPointerRemoveOperationTest() throws Fault {
        PointerRemove removeTest = new PointerRemove();
        final TestResult result = removeTest.test();
        result.eval();
    }

    /**
     * Test JSON-P API response on {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.3">RFC 6902: 4.3. replace</a>}
     * operation using RFC 6901 pointer instance.<br>
     * Checks set of simple JSON values.<br>
     * @throws Fault when this test failed.

     * @testName:      jsonPointerReplaceOperationTest
     * @assertion_ids: JSONP:JAVADOC:645; JSONP:JAVADOC:582; JSONP:JAVADOC:583; JSONP:JAVADOC:584;
     *                 JSONP:JAVADOC:661; JSONP:JAVADOC:662; JSONP:JAVADOC:663;
     * @test_Strategy: Test API response on various JSON pointer values.
     */
    public void jsonPointerReplaceOperationTest() throws Fault {
        PointerReplace replaceTest = new PointerReplace();
        final TestResult result = replaceTest.test();
        result.eval();
    }

}
