/*
 * Copyright (c) 2016 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.common;

import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonValue;

// $Id: JsonIO.java 74753 2016-12-19 11:13:34Z tkraus $
/**
 * Read and write JSON values.
 */
public class JsonIO {
    /**
     * Reads JSON value from {@code String}.
     * @param json JSON value to be read.
     * @return JSON value from provided {@code String}.
     */
    public static JsonValue read(final String json) {
        return Json.createReader(new StringReader(json)).readValue();
    }

}
