/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.ChoiceArrayQuestion;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.FloatQuestion;
import com.sun.interview.InetAddressQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.PropertiesQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringListQuestion;
import com.sun.interview.StringQuestion;
import com.sun.interview.TreeQuestion;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class WizPrint {
    private Interview interview;
    private Question[] questions;
    private BufferedWriter out;
    private boolean showResponses;
    private boolean showResponseTypes;
    private boolean showTags;
    private int state;
    private static final int IN_TAG = 1;
    private static final int IN_BODY = 2;
    private static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");
    private static final String DOCTYPE = "!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\"";
    private static final String A = "a";
    private static final String ALIGN = "align";
    private static final String B = "b";
    private static final String BODY = "body";
    private static final String BR = "br";
    private static final String FONT = "font";
    private static final String H1 = "h1";
    private static final String H3 = "h3";
    private static final String HEAD = "head";
    private static final String HR = "hr";
    private static final String HREF = "href";
    private static final String HTML = "html";
    private static final String I = "i";
    private static final String LEFT = "left";
    private static final String LI = "li";
    private static final String NAME = "name";
    private static final String P = "p";
    private static final String SIZE = "size";
    private static final String STRIKE = "strike";
    private static final String TABLE = "table";
    private static final String TITLE = "title";
    private static final String TD = "td";
    private static final String TH = "th";
    private static final String TR = "tr";
    private static final String UL = "ul";
    private static final String WIDTH = "width";

    public static void usage() {
        String prog = System.getProperty("program");
        if (prog == null) {
            prog = WizPrint.formatI18N("wp.prog", WizPrint.class.getName());
        }
        String msg = WizPrint.formatI18N("wp.usage", prog);
        boolean newline = true;
        for (int i = 0; i < msg.length(); ++i) {
            char c = msg.charAt(i);
            if (c == '\n') {
                System.err.println();
                newline = true;
                continue;
            }
            System.err.print(c);
            newline = false;
        }
        if (!newline) {
            System.err.println();
        }
    }

    public static void main(String[] args) {
        try {
            Object[] questions;
            boolean path = false;
            String interviewClassName = null;
            File interviewFile = null;
            File outFileName = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") && i + 1 < args.length) {
                    outFileName = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-path")) {
                    path = true;
                    continue;
                }
                if (args[i].equals("-all")) {
                    path = false;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    throw new BadArgs(i18n, "wp.badArg", args[i]);
                }
                if (i == args.length - 1) {
                    if (args[i].endsWith(".jti")) {
                        interviewFile = new File(args[i]);
                        continue;
                    }
                    interviewClassName = args[i];
                    continue;
                }
                throw new BadArgs(i18n, "wp.badArg", args[i]);
            }
            Properties interviewData = null;
            if (interviewFile != null) {
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(interviewFile));
                    Properties p = new Properties();
                    p.load(in);
                    interviewClassName = (String)p.get("INTERVIEW");
                    interviewData = p;
                }
                catch (FileNotFoundException e) {
                    throw new Fault(i18n, "wp.cantFindFile", interviewFile);
                }
                catch (IOException e) {
                    throw new Fault(i18n, "wp.cantReadFile", new Object[]{interviewFile, e});
                }
            }
            if (interviewClassName == null) {
                throw new BadArgs(i18n, "wp.noInterview");
            }
            if (outFileName == null) {
                String ip;
                int dot;
                if (interviewFile != null && (dot = (ip = interviewFile.getPath()).lastIndexOf(".")) != -1) {
                    outFileName = new File(ip.substring(0, dot) + ".html");
                }
                if (outFileName == null) {
                    throw new BadArgs(i18n, "wp.noOutput");
                }
            }
            Class<?> ic = Class.forName(interviewClassName);
            Interview interview = (Interview)ic.newInstance();
            if (interviewData != null) {
                interview.load(interviewData);
            }
            if (path) {
                questions = interview.getPath();
            } else {
                SortedVector v = new SortedVector();
                for (Question q : interview.getQuestions()) {
                    v.insert(q);
                }
                questions = new Question[v.size()];
                v.copyInto(questions);
            }
            try {
                FileWriter out = new FileWriter(outFileName);
                WizPrint wp = new WizPrint(interview, (Question[])questions);
                wp.setShowTags(!path);
                wp.setShowResponses(path);
                wp.setShowResponseTypes(!path);
                wp.write(out);
            }
            catch (IOException e) {
                throw new Fault(i18n, "wp.cantWriteFile", new Object[]{outFileName, e});
            }
        }
        catch (BadArgs e) {
            System.err.println(WizPrint.formatI18N("wp.error", e.getMessage()));
            WizPrint.usage();
            System.exit(1);
        }
        catch (Fault e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(3);
        }
    }

    public WizPrint(Interview interview) {
        this(interview, interview.getPath());
    }

    public WizPrint(Interview interview, Question[] questions) {
        this.interview = interview;
        this.questions = questions;
    }

    public boolean getShowResponses() {
        return this.showResponses;
    }

    public void setShowResponses(boolean showResponses) {
        this.showResponses = showResponses;
    }

    public boolean getShowResponseTypes() {
        return this.showResponseTypes;
    }

    public void setShowResponseTypes(boolean showResponseTypes) {
        this.showResponseTypes = showResponseTypes;
    }

    public boolean getShowTags() {
        return this.showTags;
    }

    public void setShowTags(boolean showTags) {
        this.showTags = showTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer o) throws IOException {
        try {
            this.setWriter(o);
            this.startTag(DOCTYPE);
            this.newLine();
            this.startTag(HTML);
            this.newLine();
            this.startTag(HEAD);
            this.writeTag(TITLE, this.interview.getTitle());
            this.endTag(HEAD);
            this.newLine();
            this.startTag(BODY);
            this.writeTag(H1, this.interview.getTitle());
            this.newLine();
            this.writeIndex();
            this.writeQuestions();
            this.endTag(BODY);
            this.endTag(HTML);
            this.newLine();
        }
        finally {
            this.out.flush();
            this.out.close();
        }
    }

    private void writeIndex() throws IOException {
        this.startTag(UL);
        this.newLine();
        for (int i = 0; i < this.questions.length; ++i) {
            Question q = this.questions[i];
            this.startTag(LI);
            this.startTag(A);
            this.writeAttr(HREF, "#" + q.getTag());
            this.writeText(q.getSummary());
            this.endTag(A);
            this.newLine();
        }
        this.endTag(UL);
        this.newLine();
        this.newLine();
    }

    private void writeQuestions() throws IOException {
        this.startTag(HR);
        for (int i = 0; i < this.questions.length; ++i) {
            Question q;
            String tag;
            if (i > 0) {
                this.startTag(P);
                this.startTag(HR);
                this.writeAttr(ALIGN, LEFT);
                this.writeAttr(WIDTH, "25%");
            }
            if ((tag = (q = this.questions[i]).getTag()) != null) {
                this.startTag(A);
                this.writeAttr(NAME, q.getTag());
                this.endTag(A);
                this.newLine();
            }
            this.writeTag(H3, q.getSummary());
            this.newLine();
            if (this.showTags) {
                this.startTag(P);
                this.startTag(I);
                this.writeI18N("wp.tag");
                if (tag == null) {
                    this.writeTag(I, "null");
                } else {
                    this.writeTag(B, tag);
                }
                this.endTag(I);
                this.endTag(P);
                this.newLine();
            }
            if (q instanceof ErrorQuestion) {
                this.startTag(P);
                this.startTag(FONT);
                this.writeAttr(SIZE, "+1");
                this.writeText(q.getText());
                this.endTag(FONT);
                this.endTag(P);
                continue;
            }
            this.startTag(P);
            this.writeText(q.getText());
            this.endTag(P);
            this.newLine();
            if (this.showResponseTypes) {
                this.writeResponseType(q);
            }
            if (!this.showResponses) continue;
            this.writeResponse(q);
        }
    }

    private void writeResponse(Question q) throws IOException {
        if (q instanceof ChoiceArrayQuestion) {
            ChoiceArrayQuestion caq = (ChoiceArrayQuestion)q;
            this.writeResponse(caq.getValue(), caq.getChoices(), caq.getDisplayChoices());
        } else if (q instanceof ChoiceQuestion) {
            ChoiceQuestion cq = (ChoiceQuestion)q;
            if (cq.getChoices() == cq.getDisplayChoices()) {
                this.writeResponse(cq.getValue());
            } else {
                this.writeResponse(cq.getValue(), cq.getDisplayValue());
            }
        } else if (!(q instanceof ErrorQuestion)) {
            if (q instanceof FileListQuestion) {
                FileListQuestion fq = (FileListQuestion)q;
                File[] f = fq.getValue();
                this.writeResponse(this.filesToStrings(f));
            } else if (q instanceof FileQuestion) {
                FileQuestion fq = (FileQuestion)q;
                File f = fq.getValue();
                this.writeResponse(f == null ? null : f.getPath());
            } else if (!(q instanceof FinalQuestion)) {
                if (q instanceof FloatQuestion) {
                    FloatQuestion fq = (FloatQuestion)q;
                    this.writeResponse(fq.getStringValue());
                } else if (q instanceof InetAddressQuestion) {
                    InetAddressQuestion iq = (InetAddressQuestion)q;
                    this.writeResponse(iq.getStringValue());
                } else if (q instanceof IntQuestion) {
                    IntQuestion iq = (IntQuestion)q;
                    this.writeResponse(iq.getStringValue());
                } else if (!(q instanceof NullQuestion)) {
                    if (q instanceof PropertiesQuestion) {
                        PropertiesQuestion pq = (PropertiesQuestion)q;
                        this.writeResponse(pq);
                    } else if (q instanceof StringQuestion) {
                        StringQuestion sq = (StringQuestion)q;
                        this.writeResponse(sq.getValue());
                    } else if (q instanceof StringListQuestion) {
                        StringListQuestion sq = (StringListQuestion)q;
                        this.writeResponse(sq.getValue());
                    } else if (q instanceof TreeQuestion) {
                        TreeQuestion tq = (TreeQuestion)q;
                        String[] nodes = tq.getValue();
                        if (nodes == null || nodes.length == 0) {
                            this.writeResponse(i18n.getString("wp.all"));
                        } else {
                            this.writeResponse(nodes);
                        }
                    } else {
                        this.writeResponse(q.getStringValue());
                    }
                }
            }
        }
    }

    private void writeResponse(String s) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (s == null) {
            this.writeI18N("wp.noResponse");
        } else {
            this.writeTag(B, s);
        }
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeResponse(String response, String displayText) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (response == null) {
            this.writeI18N("wp.noResponse");
        } else {
            this.writeTag(B, response);
            if (displayText != null) {
                this.writeText(" ");
                this.writeI18N("wp.display", displayText);
            }
        }
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeResponse(boolean[] values, String[] choices, String[] displayChoices) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (values == null) {
            this.writeI18N("wp.noResponse");
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    this.writeI18N("wp.listSep");
                }
                this.startTag(B);
                if (!values[i]) {
                    this.startTag(STRIKE);
                }
                this.writeText(choices[i]);
                if (displayChoices != null && !WizPrint.equal(choices[i], displayChoices[i])) {
                    this.writeText(" ");
                    this.writeI18N("wp.display", displayChoices[i]);
                }
                if (!values[i]) {
                    this.endTag(STRIKE);
                }
                this.endTag(B);
            }
        }
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeResponse(String[] responses) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (responses == null || responses.length == 0) {
            this.writeI18N("wp.noResponse");
            this.endTag(I);
            this.endTag(P);
        } else {
            this.endTag(I);
            this.endTag(P);
            this.startTag(UL);
            for (int i = 0; i < responses.length; ++i) {
                this.startTag(LI);
                this.startTag(B);
                this.startTag(I);
                this.writeText(responses[i]);
                this.endTag(I);
                this.endTag(B);
            }
            this.endTag(UL);
        }
        this.newLine();
        this.newLine();
    }

    private void writeResponse(PropertiesQuestion pq) throws IOException {
        String[] groups = pq.getGroups();
        String[] headers = new String[]{pq.getKeyHeaderName(), pq.getValueHeaderName()};
        String[][] nullGroup = pq.getGroup(null);
        if (nullGroup != null && nullGroup.length != 0) {
            this.writePQTable(headers, nullGroup);
        } else if (groups == null || groups.length == 0) {
            this.writeI18N("wp.noResponse");
        }
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                this.startTag(BR);
                this.startTag(B);
                this.writeText(pq.getGroupDisplayName(groups[i]));
                this.endTag(B);
                this.startTag(BR);
                this.writePQTable(headers, pq.getGroup(groups[i]));
                this.startTag(P);
            }
        }
    }

    private void writePQTable(String[] headers, String[][] values) throws IOException {
        if (values == null || values.length == 0) {
            return;
        }
        this.startTag(TABLE);
        this.writeAttr("border", "2");
        this.writeAttr(TITLE, i18n.getString("wp.table.title"));
        this.writeAttr("summary", i18n.getString("wp.table.summ"));
        this.startTag(TR);
        this.startTag(TH);
        this.writeAttr(ALIGN, LEFT);
        this.writeAttr("scope", "col");
        this.writeText(headers[0]);
        this.startTag(TH);
        this.writeAttr(ALIGN, LEFT);
        this.writeAttr("scope", "col");
        this.writeText(headers[1]);
        for (int i = 0; i < values.length; ++i) {
            this.startTag(TR);
            this.startTag(TD);
            this.writeText(values[i][0]);
            this.startTag(TD);
            this.writeText(values[i][1]);
            this.endTag(TR);
        }
        this.endTag(TABLE);
    }

    private void writeResponseType(Question q) throws IOException {
        if (q instanceof ChoiceArrayQuestion) {
            ChoiceArrayQuestion cq = (ChoiceArrayQuestion)q;
            StringBuffer sb = new StringBuffer();
            sb.append(i18n.getString("wp.type.chooseAny"));
            String[] choices = cq.getChoices();
            for (int i = 0; i < choices.length; ++i) {
                if (i > 0) {
                    sb.append(i18n.getString("wp.listSep"));
                }
                sb.append(choices[i] == null ? i18n.getString("wp.unset") : choices[i]);
            }
            this.writeResponseType(sb.toString());
        } else if (q instanceof ChoiceQuestion) {
            ChoiceQuestion cq = (ChoiceQuestion)q;
            StringBuffer sb = new StringBuffer();
            sb.append(i18n.getString("wp.type.chooseOne"));
            String[] choices = cq.getChoices();
            for (int i = 0; i < choices.length; ++i) {
                if (i > 0) {
                    sb.append(i18n.getString("wp.listSep"));
                }
                sb.append(choices[i] == null ? i18n.getString("wp.unset") : choices[i]);
            }
            this.writeResponseType(sb.toString());
        } else if (!(q instanceof ErrorQuestion)) {
            if (q instanceof FileQuestion) {
                this.writeResponseType(i18n.getString("wp.type.file"));
            } else if (q instanceof FileListQuestion) {
                this.writeResponseType(i18n.getString("wp.type.fileList"));
            } else if (!(q instanceof FinalQuestion)) {
                if (q instanceof FloatQuestion) {
                    FloatQuestion fq = (FloatQuestion)q;
                    float lwb = fq.getLowerBound();
                    float upb = fq.getUpperBound();
                    this.writeResponseType(WizPrint.formatI18N("wp.type.float", new Object[]{new Integer(lwb == Float.MIN_VALUE ? 0 : 1), new Float(lwb), new Integer(upb == Float.MAX_VALUE ? 0 : 1), new Float(upb)}));
                } else if (q instanceof InetAddressQuestion) {
                    this.writeResponseType(i18n.getString("wp.type.inetAddress"));
                } else if (q instanceof IntQuestion) {
                    IntQuestion iq = (IntQuestion)q;
                    int lwb = iq.getLowerBound();
                    int upb = iq.getUpperBound();
                    this.writeResponseType(WizPrint.formatI18N("wp.type.int", new Object[]{new Integer(lwb == Integer.MIN_VALUE ? 0 : 1), new Integer(lwb), new Integer(upb == Integer.MAX_VALUE ? 0 : 1), new Integer(upb)}));
                } else if (!(q instanceof NullQuestion)) {
                    if (q instanceof StringQuestion) {
                        this.writeResponseType(i18n.getString("wp.type.string"));
                    } else if (q instanceof StringListQuestion) {
                        this.writeResponseType(i18n.getString("wp.type.stringList"));
                    } else if (q instanceof TreeQuestion) {
                        this.writeResponseType(i18n.getString("wp.type.tree"));
                    } else {
                        this.startTag(P);
                        this.writeTag(I, "unknown type of question; cannot determine response type");
                        this.endTag(P);
                    }
                }
            }
        }
    }

    private void writeResponseType(String s) throws IOException {
        this.startTag(P);
        this.startTag(I);
        if (this.showResponseTypes && this.showResponses) {
            this.writeI18N("wp.responseType");
        } else {
            this.writeI18N("wp.response");
        }
        this.startTag(B);
        this.writeText(s);
        this.endTag(B);
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeI18N(String key) throws IOException {
        this.writeText(i18n.getString(key));
    }

    private void writeI18N(String key, Object arg) throws IOException {
        String s = WizPrint.formatI18N(key, arg);
        this.writeText(s);
    }

    private String[] filesToStrings(File[] f) {
        if (f == null) {
            return null;
        }
        String[] s = new String[f.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = f[i].getPath();
        }
        return s;
    }

    private void newLine() throws IOException {
        if (this.state == 1) {
            this.out.write(62);
            this.state = 2;
        }
        this.out.newLine();
    }

    private void startTag(String t) throws IOException {
        if (this.state == 1) {
            this.out.write(62);
        }
        this.out.write(60);
        this.out.write(t);
        this.state = 1;
    }

    private void endTag(String t) throws IOException {
        if (this.state == 1) {
            this.out.write(62);
        }
        this.out.write("</");
        this.out.write(t);
        this.out.write(62);
        this.state = 2;
    }

    private void writeAttr(String name, String value) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(" ");
        this.out.write(name);
        this.out.write("=");
        boolean alpha = true;
        for (int i = 0; i < value.length() && alpha; ++i) {
            alpha = Character.isLetter(value.charAt(i));
        }
        if (!alpha) {
            this.out.write("\"");
        }
        this.out.write(value);
        if (!alpha) {
            this.out.write("\"");
        }
    }

    private void writeTag(String t, String s) throws IOException {
        this.startTag(t);
        this.writeText(s);
        this.endTag(t);
    }

    private void writeText(String s) throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        if (s == null) {
            this.out.write("<i>");
            this.out.write(i18n.getString("wp.null"));
            this.out.write("</i>");
        } else {
            block6: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\n': {
                        this.out.write("<br>");
                        continue block6;
                    }
                    case '<': {
                        this.out.write("&lt;");
                        continue block6;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        continue block6;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        continue block6;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
        }
    }

    private static String formatI18N(String key, Object arg) {
        return MessageFormat.format(i18n.getString(key), arg);
    }

    private static String formatI18N(String key, Object[] args) {
        return MessageFormat.format(i18n.getString(key), args);
    }

    private void setWriter(Writer o) {
        this.out = this.out instanceof BufferedWriter ? (BufferedWriter)o : new BufferedWriter(o);
    }

    private static boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private static class SortedVector {
        private Vector v;

        public SortedVector() {
            this.v = new Vector();
        }

        public SortedVector(int initialSize) {
            this.v = new Vector(initialSize);
        }

        public int size() {
            return this.v.size();
        }

        public Object elementAt(int index) {
            return this.v.elementAt(index);
        }

        public void insert(Object o) {
            this.v.insertElementAt(o, this.findSortIndex(o));
        }

        public void insert(Object o, boolean ignoreDuplicates) {
            int i = this.findSortIndex(o);
            if (ignoreDuplicates && i < this.v.size() && this.compare(o, this.v.elementAt(i)) == 0) {
                return;
            }
            this.v.insertElementAt(o, i);
        }

        public void copyInto(Object[] target) {
            this.v.copyInto(target);
        }

        protected int compare(Object o1, Object o2) {
            String p1 = ((Question)o1).getTag();
            String p2 = ((Question)o2).getTag();
            if (p1 == null && p2 == null) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            return p1.compareTo(p2);
        }

        private int findSortIndex(Object o) {
            int lower = 0;
            int upper = this.v.size() - 1;
            int mid = 0;
            if (upper == -1) {
                return 0;
            }
            int cmp = 0;
            Object last = this.v.elementAt(upper);
            cmp = this.compare(o, last);
            if (cmp > 0) {
                return upper + 1;
            }
            while (lower <= upper) {
                mid = lower + (upper - lower) / 2;
                Object entry = this.v.elementAt(mid);
                cmp = this.compare(o, entry);
                if (cmp == 0) {
                    return mid;
                }
                if (cmp < 0) {
                    upper = mid - 1;
                    continue;
                }
                lower = mid + 1;
            }
            return cmp < 0 ? mid : mid + 1;
        }
    }

    public static class Fault
    extends Exception {
        public Fault(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        public Fault(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        public Fault(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }

    public static class BadArgs
    extends Exception {
        public BadArgs(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        public BadArgs(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        public BadArgs(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }
}

