/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.defaultmapping.uniqueness;

import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.uniqueness.model.SimpleContainer;

import java.util.Properties;

/**
 * @test
 * @sources PropertyUniquenessTest.java
 * @executeClass com.sun.ts.tests.jsonb.defaultmapping.uniqueness.PropertyUniquenessTest
 **/
public class PropertyUniquenessTest extends ServiceEETest {
	private static final long serialVersionUID = 10L;
	private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        EETest t = new PropertyUniquenessTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     * @testName:   testUniqueProperties
     *
     * @assertion_ids:  JSONB:SPEC:JSB-3.19-1; JSONB:SPEC:JSB-3.19-2
     *
     * @test_Strategy:  Assert that an exception is thrown when duplicate property names exist
     */
    public Status testUniqueProperties() throws Fault {
        try {
            jsonb.toJson(new SimpleContainer());
            throw new Fault("An exception is expected when marshalling a class with duplicate attribute names.");
        } catch (JsonbException x) {
            return Status.passed("OK");
        }
    }
}
