/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.serializers.model.serializer;

import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;

import com.sun.ts.tests.jsonb.customizedmapping.serializers.model.Animal;

import java.util.List;

public class AnimalListSerializer implements JsonbSerializer<List<Animal>> {
    private AnimalSerializer animalSerializer = new AnimalSerializer();

    public void serialize(List<Animal> animals, JsonGenerator jsonGenerator, SerializationContext serializationContext) {
        jsonGenerator.writeStartArray();
        for (Animal animal : animals) {
            animalSerializer.serialize(animal, jsonGenerator, serializationContext);
        }
        jsonGenerator.writeEnd();
    }
}
