/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.serializers.model.serializer;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;

import com.sun.ts.tests.jsonb.customizedmapping.serializers.model.Animal;

public class AnimalListDeserializer implements JsonbDeserializer<List<Animal>> {
    private AnimalDeserializer animalDeserializer = new AnimalDeserializer();

    public List<Animal> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Type type) {
        List<Animal> animals = new ArrayList<>();
        while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            while (event == JsonParser.Event.START_OBJECT) {
                animals.add(animalDeserializer.deserialize(jsonParser, deserializationContext, type));
                event = jsonParser.next();
            }
        }
        return animals;
    }
}
