/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)SignatureTestTag.java	1.1 04/11/05
 */
package com.sun.ts.tests.jsf.spec.webapp.tldsig;

import java.io.IOException;
import java.util.List;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * This is only used to associate a TagExtraInfo with.
 */
public class SignatureTestTag extends TagSupport {


    // -------------------------------------- Methods from javax.servlet.jsp.Tag

    public int doEndTag() throws JspException {
        List messages = (List)
            pageContext.getAttribute("com.sun.tck.taglibsig.failedmessages",
                                     PageContext.APPLICATION_SCOPE);

        JspWriter out = pageContext.getOut();
        if (messages.size() > 0) {
            try {
                out.println("The following Taglibraries FAILED");
                out.println("----------------------------------------------\n");
                out.println();
                for (int i = 0, size = messages.size(); i < size; i++) {
                    out.println(messages.get(i));
                }
                out.println('\n');
            } catch (IOException ioe) {
                throw new JspException(ioe);
            }
        }

        messages = (List)
                    pageContext.getAttribute("com.sun.tck.taglibsig.passedmessages",
                                     PageContext.APPLICATION_SCOPE);
        if (messages.size() > 0) {
            try {
                out.println("The following Taglibraries PASSED");
                out.println("----------------------------------------------\n");                
                for (int i = 0, size = messages.size(); i < size; i++) {
                    out.println(messages.get(i));
                }
                out.println('\n');
            } catch (IOException ioe) {
                throw new JspException(ioe);
            }
        }

        try {
            out.println("\n\nNOTE:  In order to see any changes to the" +
                    " result, the test application must be redeployed");
        } catch (IOException ioe) {
            throw new JspException(ioe);
        }

        return super.doEndTag();

    } // END doEndTag

}
